@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Collection of static site custom users.
 * @property nextLink Link to next page of resources.
 * @property value Collection of resources.
 */
public data class ListStaticSiteUsersResult(
    public val nextLink: String,
    public val `value`: List<StaticSiteUserARMResourceResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.ListStaticSiteUsersResult):
            ListStaticSiteUsersResult = ListStaticSiteUsersResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.StaticSiteUserARMResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
