@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The status of the last successful slot swap operation.
 * @property destinationSlotName The destination slot of the last swap operation.
 * @property sourceSlotName The source slot of the last swap operation.
 * @property timestampUtc The time the last successful slot swap completed.
 */
public data class SlotSwapStatusResponse(
    public val destinationSlotName: String,
    public val sourceSlotName: String,
    public val timestampUtc: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.SlotSwapStatusResponse):
            SlotSwapStatusResponse = SlotSwapStatusResponse(
            destinationSlotName = javaType.destinationSlotName(),
            sourceSlotName = javaType.sourceSlotName(),
            timestampUtc = javaType.timestampUtc(),
        )
    }
}
