@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A database connection configuration file
 * @property contents The Base64 encoding of the file contents.
 * @property fileName The name of the configuration file.
 * @property type The type of configuration file.
 */
public data class StaticSiteDatabaseConnectionConfigurationFileOverviewResponse(
    public val contents: String,
    public val fileName: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.StaticSiteDatabaseConnectionConfigurationFileOverviewResponse):
            StaticSiteDatabaseConnectionConfigurationFileOverviewResponse =
            StaticSiteDatabaseConnectionConfigurationFileOverviewResponse(
                contents = javaType.contents(),
                fileName = javaType.fileName(),
                type = javaType.type(),
            )
    }
}
