@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Additional workflow properties.
 * @property files Gets or sets the files.
 * @property flowState Gets or sets the state of the workflow.
 * @property health Gets or sets workflow health.
 */
public data class WorkflowEnvelopeResponseProperties(
    public val files: Map<String, Any>? = null,
    public val flowState: String? = null,
    public val health: WorkflowHealthResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.WorkflowEnvelopeResponseProperties):
            WorkflowEnvelopeResponseProperties = WorkflowEnvelopeResponseProperties(
            files = javaType.files().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            flowState = javaType.flowState().map({ args0 -> args0 }).orElse(null),
            health = javaType.health().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.WorkflowHealthResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
