@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The WSDL definition
 * @property content The WSDL content
 * @property importMethod The WSDL import method
 * @property service The service with name and endpoint names
 * @property url The WSDL URL
 */
public data class WsdlDefinitionResponse(
    public val content: String? = null,
    public val importMethod: String? = null,
    public val service: WsdlServiceResponse? = null,
    public val url: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.WsdlDefinitionResponse):
            WsdlDefinitionResponse = WsdlDefinitionResponse(
            content = javaType.content().map({ args0 -> args0 }).orElse(null),
            importMethod = javaType.importMethod().map({ args0 -> args0 }).orElse(null),
            service = javaType.service().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.web.kotlin.outputs.WsdlServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
