@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.web.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The service with name and endpoint names
 * @property endpointQualifiedNames List of the endpoints' qualified names
 * @property qualifiedName The service's qualified name
 */
public data class WsdlServiceResponse(
    public val endpointQualifiedNames: List<String>? = null,
    public val qualifiedName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.web.outputs.WsdlServiceResponse):
            WsdlServiceResponse = WsdlServiceResponse(
            endpointQualifiedNames = javaType.endpointQualifiedNames().map({ args0 -> args0 }),
            qualifiedName = javaType.qualifiedName(),
        )
    }
}
