@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.WebPubSubArgs.builder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.LiveTraceConfigurationArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.LiveTraceConfigurationArgsBuilder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ManagedIdentityArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ManagedIdentityArgsBuilder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ResourceLogConfigurationArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ResourceLogConfigurationArgsBuilder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ResourceSkuArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.ResourceSkuArgsBuilder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.WebPubSubNetworkACLsArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.WebPubSubNetworkACLsArgsBuilder
import com.pulumi.azurenative.webpubsub.kotlin.inputs.WebPubSubTlsSettingsArgs
import com.pulumi.azurenative.webpubsub.kotlin.inputs.WebPubSubTlsSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A class represent a resource.
 * Azure REST API version: 2023-02-01. Prior API version in Azure Native 1.x: 2021-04-01-preview.
 * Other available API versions: 2021-04-01-preview, 2021-06-01-preview, 2021-09-01-preview, 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### WebPubSub_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSub = new AzureNative.WebPubSub.WebPubSub("webPubSub", new()
 *     {
 *         DisableAadAuth = false,
 *         DisableLocalAuth = false,
 *         Identity = new AzureNative.WebPubSub.Inputs.ManagedIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         LiveTraceConfiguration = new AzureNative.WebPubSub.Inputs.LiveTraceConfigurationArgs
 *         {
 *             Categories = new[]
 *             {
 *                 new AzureNative.WebPubSub.Inputs.LiveTraceCategoryArgs
 *                 {
 *                     Enabled = "true",
 *                     Name = "ConnectivityLogs",
 *                 },
 *             },
 *             Enabled = "false",
 *         },
 *         Location = "eastus",
 *         NetworkACLs = new AzureNative.WebPubSub.Inputs.WebPubSubNetworkACLsArgs
 *         {
 *             DefaultAction = "Deny",
 *             PrivateEndpoints = new[]
 *             {
 *                 new AzureNative.WebPubSub.Inputs.PrivateEndpointACLArgs
 *                 {
 *                     Allow = new[]
 *                     {
 *                         "ServerConnection",
 *                     },
 *                     Name = "mywebpubsubservice.1fa229cd-bf3f-47f0-8c49-afb36723997e",
 *                 },
 *             },
 *             PublicNetwork = new AzureNative.WebPubSub.Inputs.NetworkACLArgs
 *             {
 *                 Allow = new[]
 *                 {
 *                     "ClientConnection",
 *                 },
 *             },
 *         },
 *         PublicNetworkAccess = "Enabled",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *         Sku = new AzureNative.WebPubSub.Inputs.ResourceSkuArgs
 *         {
 *             Capacity = 1,
 *             Name = "Premium_P1",
 *             Tier = "Premium",
 *         },
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *         Tls = new AzureNative.WebPubSub.Inputs.WebPubSubTlsSettingsArgs
 *         {
 *             ClientCertEnabled = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSub(ctx, "webPubSub", &webpubsub.WebPubSubArgs{
 * 			DisableAadAuth:   pulumi.Bool(false),
 * 			DisableLocalAuth: pulumi.Bool(false),
 * 			Identity: &webpubsub.ManagedIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			LiveTraceConfiguration: webpubsub.LiveTraceConfigurationResponse{
 * 				Categories: webpubsub.LiveTraceCategoryArray{
 * 					&webpubsub.LiveTraceCategoryArgs{
 * 						Enabled: pulumi.String("true"),
 * 						Name:    pulumi.String("ConnectivityLogs"),
 * 					},
 * 				},
 * 				Enabled: pulumi.String("false"),
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			NetworkACLs: webpubsub.WebPubSubNetworkACLsResponse{
 * 				DefaultAction: pulumi.String("Deny"),
 * 				PrivateEndpoints: webpubsub.PrivateEndpointACLArray{
 * 					&webpubsub.PrivateEndpointACLArgs{
 * 						Allow: pulumi.StringArray{
 * 							pulumi.String("ServerConnection"),
 * 						},
 * 						Name: pulumi.String("mywebpubsubservice.1fa229cd-bf3f-47f0-8c49-afb36723997e"),
 * 					},
 * 				},
 * 				PublicNetwork: &webpubsub.NetworkACLArgs{
 * 					Allow: pulumi.StringArray{
 * 						pulumi.String("ClientConnection"),
 * 					},
 * 				},
 * 			},
 * 			PublicNetworkAccess: pulumi.String("Enabled"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ResourceName:        pulumi.String("myWebPubSubService"),
 * 			Sku: &webpubsub.ResourceSkuArgs{
 * 				Capacity: pulumi.Int(1),
 * 				Name:     pulumi.String("Premium_P1"),
 * 				Tier:     pulumi.String("Premium"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 			Tls: &webpubsub.WebPubSubTlsSettingsArgs{
 * 				ClientCertEnabled: pulumi.Bool(false),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSub;
 * import com.pulumi.azurenative.webpubsub.WebPubSubArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSub = new WebPubSub("webPubSub", WebPubSubArgs.builder()
 *             .disableAadAuth(false)
 *             .disableLocalAuth(false)
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .liveTraceConfiguration(Map.ofEntries(
 *                 Map.entry("categories", Map.ofEntries(
 *                     Map.entry("enabled", "true"),
 *                     Map.entry("name", "ConnectivityLogs")
 *                 )),
 *                 Map.entry("enabled", "false")
 *             ))
 *             .location("eastus")
 *             .networkACLs(Map.ofEntries(
 *                 Map.entry("defaultAction", "Deny"),
 *                 Map.entry("privateEndpoints", Map.ofEntries(
 *                     Map.entry("allow", "ServerConnection"),
 *                     Map.entry("name", "mywebpubsubservice.1fa229cd-bf3f-47f0-8c49-afb36723997e")
 *                 )),
 *                 Map.entry("publicNetwork", Map.of("allow", "ClientConnection"))
 *             ))
 *             .publicNetworkAccess("Enabled")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .sku(Map.ofEntries(
 *                 Map.entry("capacity", 1),
 *                 Map.entry("name", "Premium_P1"),
 *                 Map.entry("tier", "Premium")
 *             ))
 *             .tags(Map.of("key1", "value1"))
 *             .tls(Map.of("clientCertEnabled", false))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSub myWebPubSubService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}
 * ```
 * @property disableAadAuth DisableLocalAuth
 * Enable or disable aad auth
 * When set as true, connection with AuthType=aad won't work.
 * @property disableLocalAuth DisableLocalAuth
 * Enable or disable local auth with AccessKey
 * When set as true, connection with AccessKey=xxx won't work.
 * @property identity A class represent managed identities used for request and response
 * @property liveTraceConfiguration Live trace configuration of a Microsoft.SignalRService resource.
 * @property location The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
 * @property networkACLs Network ACLs for the resource
 * @property publicNetworkAccess Enable or disable public network access. Default to "Enabled".
 * When it's Enabled, network ACLs still apply.
 * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceLogConfiguration Resource log configuration of a Microsoft.SignalRService resource.
 * @property resourceName The name of the resource.
 * @property sku The billing information of the resource.
 * @property tags Tags of the service which is a list of key value pairs that describe the resource.
 * @property tls TLS settings for the resource
 */
public data class WebPubSubArgs(
    public val disableAadAuth: Output<Boolean>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val liveTraceConfiguration: Output<LiveTraceConfigurationArgs>? = null,
    public val location: Output<String>? = null,
    public val networkACLs: Output<WebPubSubNetworkACLsArgs>? = null,
    public val publicNetworkAccess: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceLogConfiguration: Output<ResourceLogConfigurationArgs>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<ResourceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tls: Output<WebPubSubTlsSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.WebPubSubArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.WebPubSubArgs =
        com.pulumi.azurenative.webpubsub.WebPubSubArgs.builder()
            .disableAadAuth(disableAadAuth?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .liveTraceConfiguration(
                liveTraceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .networkACLs(networkACLs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .publicNetworkAccess(publicNetworkAccess?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceLogConfiguration(
                resourceLogConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebPubSubArgs].
 */
@PulumiTagMarker
public class WebPubSubArgsBuilder internal constructor() {
    private var disableAadAuth: Output<Boolean>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var identity: Output<ManagedIdentityArgs>? = null

    private var liveTraceConfiguration: Output<LiveTraceConfigurationArgs>? = null

    private var location: Output<String>? = null

    private var networkACLs: Output<WebPubSubNetworkACLsArgs>? = null

    private var publicNetworkAccess: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceLogConfiguration: Output<ResourceLogConfigurationArgs>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<ResourceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tls: Output<WebPubSubTlsSettingsArgs>? = null

    /**
     * @param value DisableLocalAuth
     * Enable or disable aad auth
     * When set as true, connection with AuthType=aad won't work.
     */
    @JvmName("utwemqrmwbspyapi")
    public suspend fun disableAadAuth(`value`: Output<Boolean>) {
        this.disableAadAuth = value
    }

    /**
     * @param value DisableLocalAuth
     * Enable or disable local auth with AccessKey
     * When set as true, connection with AccessKey=xxx won't work.
     */
    @JvmName("pxofoyjfhkbllsdl")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value A class represent managed identities used for request and response
     */
    @JvmName("kppuhaueqlqlbxxn")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Live trace configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("jkfbqrwxngnlnqbg")
    public suspend fun liveTraceConfiguration(`value`: Output<LiveTraceConfigurationArgs>) {
        this.liveTraceConfiguration = value
    }

    /**
     * @param value The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
     */
    @JvmName("cyuwbfxfjfrcjidx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Network ACLs for the resource
     */
    @JvmName("tinbntsnuwdendeb")
    public suspend fun networkACLs(`value`: Output<WebPubSubNetworkACLsArgs>) {
        this.networkACLs = value
    }

    /**
     * @param value Enable or disable public network access. Default to "Enabled".
     * When it's Enabled, network ACLs still apply.
     * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
     */
    @JvmName("fvfacwkhgyuaepfj")
    public suspend fun publicNetworkAccess(`value`: Output<String>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("oxtupdkurcqvictm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource log configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("behgnyumwmubongs")
    public suspend fun resourceLogConfiguration(`value`: Output<ResourceLogConfigurationArgs>) {
        this.resourceLogConfiguration = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("bmwkflanevstfixo")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The billing information of the resource.
     */
    @JvmName("ucwixmxujgwxqnag")
    public suspend fun sku(`value`: Output<ResourceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("olfflnvqrpqlytdy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value TLS settings for the resource
     */
    @JvmName("npabtdfmqqfnmnxw")
    public suspend fun tls(`value`: Output<WebPubSubTlsSettingsArgs>) {
        this.tls = value
    }

    /**
     * @param value DisableLocalAuth
     * Enable or disable aad auth
     * When set as true, connection with AuthType=aad won't work.
     */
    @JvmName("bwymktkksvpgpfad")
    public suspend fun disableAadAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableAadAuth = mapped
    }

    /**
     * @param value DisableLocalAuth
     * Enable or disable local auth with AccessKey
     * When set as true, connection with AccessKey=xxx won't work.
     */
    @JvmName("uyxftrvwxkxtbycv")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value A class represent managed identities used for request and response
     */
    @JvmName("kxxbxavwgbhifxas")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument A class represent managed identities used for request and response
     */
    @JvmName("dlktolfsuuswydun")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Live trace configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("sccyqwwyjyinisgf")
    public suspend fun liveTraceConfiguration(`value`: LiveTraceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.liveTraceConfiguration = mapped
    }

    /**
     * @param argument Live trace configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("yyfwppjjcgjibmia")
    public suspend
    fun liveTraceConfiguration(argument: suspend LiveTraceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = LiveTraceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.liveTraceConfiguration = mapped
    }

    /**
     * @param value The GEO location of the resource. e.g. West US | East US | North Central US | South Central US.
     */
    @JvmName("rcmllcosqsiibhtu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Network ACLs for the resource
     */
    @JvmName("xovdwdkdtovbycgy")
    public suspend fun networkACLs(`value`: WebPubSubNetworkACLsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkACLs = mapped
    }

    /**
     * @param argument Network ACLs for the resource
     */
    @JvmName("iluaxrqjecktfahd")
    public suspend fun networkACLs(argument: suspend WebPubSubNetworkACLsArgsBuilder.() -> Unit) {
        val toBeMapped = WebPubSubNetworkACLsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkACLs = mapped
    }

    /**
     * @param value Enable or disable public network access. Default to "Enabled".
     * When it's Enabled, network ACLs still apply.
     * When it's Disabled, public network access is always disabled no matter what you set in network ACLs.
     */
    @JvmName("rlhtmlyaobomrllo")
    public suspend fun publicNetworkAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dsoujbiqagvjcohf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource log configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("krnqkfcsejjieowq")
    public suspend fun resourceLogConfiguration(`value`: ResourceLogConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLogConfiguration = mapped
    }

    /**
     * @param argument Resource log configuration of a Microsoft.SignalRService resource.
     */
    @JvmName("bimqpresdfbiiwex")
    public suspend
    fun resourceLogConfiguration(argument: suspend ResourceLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceLogConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceLogConfiguration = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("yvjsjgsdkotvlgkm")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The billing information of the resource.
     */
    @JvmName("xmbgplqsfjucpckp")
    public suspend fun sku(`value`: ResourceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The billing information of the resource.
     */
    @JvmName("slrtgtqanrcqvsqb")
    public suspend fun sku(argument: suspend ResourceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("vjlbxuixherygvsy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the service which is a list of key value pairs that describe the resource.
     */
    @JvmName("vygxabsxyxreydpx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value TLS settings for the resource
     */
    @JvmName("wqlqrkjdcuogiyql")
    public suspend fun tls(`value`: WebPubSubTlsSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument TLS settings for the resource
     */
    @JvmName("hypmptjadmtukylh")
    public suspend fun tls(argument: suspend WebPubSubTlsSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = WebPubSubTlsSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): WebPubSubArgs = WebPubSubArgs(
        disableAadAuth = disableAadAuth,
        disableLocalAuth = disableLocalAuth,
        identity = identity,
        liveTraceConfiguration = liveTraceConfiguration,
        location = location,
        networkACLs = networkACLs,
        publicNetworkAccess = publicNetworkAccess,
        resourceGroupName = resourceGroupName,
        resourceLogConfiguration = resourceLogConfiguration,
        resourceName = resourceName,
        sku = sku,
        tags = tags,
        tls = tls,
    )
}
