@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebPubSubCustomCertificate].
 */
@PulumiTagMarker
public class WebPubSubCustomCertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebPubSubCustomCertificateArgs = WebPubSubCustomCertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebPubSubCustomCertificateArgsBuilder.() -> Unit) {
        val builder = WebPubSubCustomCertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebPubSubCustomCertificate {
        val builtJavaResource =
            com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebPubSubCustomCertificate(builtJavaResource)
    }
}

/**
 * A custom certificate.
 * Azure REST API version: 2023-02-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### WebPubSubCustomCertificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSubCustomCertificate = new AzureNative.WebPubSub.WebPubSubCustomCertificate("webPubSubCustomCertificate", new()
 *     {
 *         CertificateName = "myCert",
 *         KeyVaultBaseUri = "https://myvault.keyvault.azure.net/",
 *         KeyVaultSecretName = "mycert",
 *         KeyVaultSecretVersion = "bb6a44b2743f47f68dad0d6cc9756432",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSubCustomCertificate(ctx, "webPubSubCustomCertificate", &webpubsub.WebPubSubCustomCertificateArgs{
 * 			CertificateName:       pulumi.String("myCert"),
 * 			KeyVaultBaseUri:       pulumi.String("https://myvault.keyvault.azure.net/"),
 * 			KeyVaultSecretName:    pulumi.String("mycert"),
 * 			KeyVaultSecretVersion: pulumi.String("bb6a44b2743f47f68dad0d6cc9756432"),
 * 			ResourceGroupName:     pulumi.String("myResourceGroup"),
 * 			ResourceName:          pulumi.String("myWebPubSubService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificate;
 * import com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSubCustomCertificate = new WebPubSubCustomCertificate("webPubSubCustomCertificate", WebPubSubCustomCertificateArgs.builder()
 *             .certificateName("myCert")
 *             .keyVaultBaseUri("https://myvault.keyvault.azure.net/")
 *             .keyVaultSecretName("mycert")
 *             .keyVaultSecretVersion("bb6a44b2743f47f68dad0d6cc9756432")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSubCustomCertificate myCert /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}/customCertificates/{certificateName}
 * ```
 */
public class WebPubSubCustomCertificate internal constructor(
    override val javaResource: com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificate,
) : KotlinCustomResource(javaResource, WebPubSubCustomCertificateMapper) {
    /**
     * Base uri of the KeyVault that stores certificate.
     */
    public val keyVaultBaseUri: Output<String>
        get() = javaResource.keyVaultBaseUri().applyValue({ args0 -> args0 })

    /**
     * Certificate secret name.
     */
    public val keyVaultSecretName: Output<String>
        get() = javaResource.keyVaultSecretName().applyValue({ args0 -> args0 })

    /**
     * Certificate secret version.
     */
    public val keyVaultSecretVersion: Output<String>?
        get() = javaResource.keyVaultSecretVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebPubSubCustomCertificateMapper : ResourceMapper<WebPubSubCustomCertificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificate::class == javaResource::class

    override fun map(javaResource: Resource): WebPubSubCustomCertificate =
        WebPubSubCustomCertificate(
            javaResource as
                com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificate,
        )
}

/**
 * @see [WebPubSubCustomCertificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebPubSubCustomCertificate].
 */
public suspend fun webPubSubCustomCertificate(
    name: String,
    block: suspend WebPubSubCustomCertificateResourceBuilder.() -> Unit,
):
    WebPubSubCustomCertificate {
    val builder = WebPubSubCustomCertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebPubSubCustomCertificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webPubSubCustomCertificate(name: String): WebPubSubCustomCertificate {
    val builder = WebPubSubCustomCertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
