@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin

import com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A custom certificate.
 * Azure REST API version: 2023-02-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview, 2023-08-01-preview.
 * ## Example Usage
 * ### WebPubSubCustomCertificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webPubSubCustomCertificate = new AzureNative.WebPubSub.WebPubSubCustomCertificate("webPubSubCustomCertificate", new()
 *     {
 *         CertificateName = "myCert",
 *         KeyVaultBaseUri = "https://myvault.keyvault.azure.net/",
 *         KeyVaultSecretName = "mycert",
 *         KeyVaultSecretVersion = "bb6a44b2743f47f68dad0d6cc9756432",
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "myWebPubSubService",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/webpubsub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := webpubsub.NewWebPubSubCustomCertificate(ctx, "webPubSubCustomCertificate", &webpubsub.WebPubSubCustomCertificateArgs{
 * 			CertificateName:       pulumi.String("myCert"),
 * 			KeyVaultBaseUri:       pulumi.String("https://myvault.keyvault.azure.net/"),
 * 			KeyVaultSecretName:    pulumi.String("mycert"),
 * 			KeyVaultSecretVersion: pulumi.String("bb6a44b2743f47f68dad0d6cc9756432"),
 * 			ResourceGroupName:     pulumi.String("myResourceGroup"),
 * 			ResourceName:          pulumi.String("myWebPubSubService"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificate;
 * import com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webPubSubCustomCertificate = new WebPubSubCustomCertificate("webPubSubCustomCertificate", WebPubSubCustomCertificateArgs.builder()
 *             .certificateName("myCert")
 *             .keyVaultBaseUri("https://myvault.keyvault.azure.net/")
 *             .keyVaultSecretName("mycert")
 *             .keyVaultSecretVersion("bb6a44b2743f47f68dad0d6cc9756432")
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("myWebPubSubService")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:webpubsub:WebPubSubCustomCertificate myCert /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SignalRService/webPubSub/{resourceName}/customCertificates/{certificateName}
 * ```
 * @property certificateName Custom certificate name
 * @property keyVaultBaseUri Base uri of the KeyVault that stores certificate.
 * @property keyVaultSecretName Certificate secret name.
 * @property keyVaultSecretVersion Certificate secret version.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property resourceName The name of the resource.
 */
public data class WebPubSubCustomCertificateArgs(
    public val certificateName: Output<String>? = null,
    public val keyVaultBaseUri: Output<String>? = null,
    public val keyVaultSecretName: Output<String>? = null,
    public val keyVaultSecretVersion: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificateArgs =
        com.pulumi.azurenative.webpubsub.WebPubSubCustomCertificateArgs.builder()
            .certificateName(certificateName?.applyValue({ args0 -> args0 }))
            .keyVaultBaseUri(keyVaultBaseUri?.applyValue({ args0 -> args0 }))
            .keyVaultSecretName(keyVaultSecretName?.applyValue({ args0 -> args0 }))
            .keyVaultSecretVersion(keyVaultSecretVersion?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebPubSubCustomCertificateArgs].
 */
@PulumiTagMarker
public class WebPubSubCustomCertificateArgsBuilder internal constructor() {
    private var certificateName: Output<String>? = null

    private var keyVaultBaseUri: Output<String>? = null

    private var keyVaultSecretName: Output<String>? = null

    private var keyVaultSecretVersion: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Custom certificate name
     */
    @JvmName("nukuhxitqqxxbgol")
    public suspend fun certificateName(`value`: Output<String>) {
        this.certificateName = value
    }

    /**
     * @param value Base uri of the KeyVault that stores certificate.
     */
    @JvmName("cmmobprgmfkehrqk")
    public suspend fun keyVaultBaseUri(`value`: Output<String>) {
        this.keyVaultBaseUri = value
    }

    /**
     * @param value Certificate secret name.
     */
    @JvmName("sykpbocyspijhadg")
    public suspend fun keyVaultSecretName(`value`: Output<String>) {
        this.keyVaultSecretName = value
    }

    /**
     * @param value Certificate secret version.
     */
    @JvmName("wxjcgoypfscsyabb")
    public suspend fun keyVaultSecretVersion(`value`: Output<String>) {
        this.keyVaultSecretVersion = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kgvxubiuoadqqgnv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("qadbkbyftdtieetp")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Custom certificate name
     */
    @JvmName("hibdmbvcrphpcnup")
    public suspend fun certificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateName = mapped
    }

    /**
     * @param value Base uri of the KeyVault that stores certificate.
     */
    @JvmName("tedwseixcugxxuoj")
    public suspend fun keyVaultBaseUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultBaseUri = mapped
    }

    /**
     * @param value Certificate secret name.
     */
    @JvmName("ccbijxrkxguvlvri")
    public suspend fun keyVaultSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretName = mapped
    }

    /**
     * @param value Certificate secret version.
     */
    @JvmName("feipvrotlhkyyawl")
    public suspend fun keyVaultSecretVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretVersion = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("pkapdfptrglbljqg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("lrxfeudopurofitm")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): WebPubSubCustomCertificateArgs = WebPubSubCustomCertificateArgs(
        certificateName = certificateName,
        keyVaultBaseUri = keyVaultBaseUri,
        keyVaultSecretName = keyVaultSecretName,
        keyVaultSecretVersion = keyVaultSecretVersion,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
