@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.EventHandlerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of event handler.
 * @property auth Upstream auth settings. If not set, no auth is used for upstream messages.
 * @property systemEvents Gets or sets the list of system events.
 * @property urlTemplate Gets or sets the EventHandler URL template. You can use a predefined parameter {hub} and {event} inside the template, the value of the EventHandler URL is dynamically calculated when the client request comes in.
 * For example, UrlTemplate can be `http://example.com/api/{hub}/{event}`. The host part can't contains parameters.
 * @property userEventPattern Gets or sets the matching pattern for event names.
 * There are 3 kinds of patterns supported:
 *     1. "*", it matches any event name
 *     2. Combine multiple events with ",", for example "event1,event2", it matches event "event1" and "event2"
 *     3. A single event name, for example, "event1", it matches "event1"
 */
public data class EventHandlerArgs(
    public val auth: Output<UpstreamAuthSettingsArgs>? = null,
    public val systemEvents: Output<List<String>>? = null,
    public val urlTemplate: Output<String>,
    public val userEventPattern: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.EventHandlerArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.EventHandlerArgs =
        com.pulumi.azurenative.webpubsub.inputs.EventHandlerArgs.builder()
            .auth(auth?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .systemEvents(systemEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .urlTemplate(urlTemplate.applyValue({ args0 -> args0 }))
            .userEventPattern(userEventPattern?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHandlerArgs].
 */
@PulumiTagMarker
public class EventHandlerArgsBuilder internal constructor() {
    private var auth: Output<UpstreamAuthSettingsArgs>? = null

    private var systemEvents: Output<List<String>>? = null

    private var urlTemplate: Output<String>? = null

    private var userEventPattern: Output<String>? = null

    /**
     * @param value Upstream auth settings. If not set, no auth is used for upstream messages.
     */
    @JvmName("maslxejrhpuwwccw")
    public suspend fun auth(`value`: Output<UpstreamAuthSettingsArgs>) {
        this.auth = value
    }

    /**
     * @param value Gets or sets the list of system events.
     */
    @JvmName("wdifluppwupixunh")
    public suspend fun systemEvents(`value`: Output<List<String>>) {
        this.systemEvents = value
    }

    @JvmName("ajklgaorivqhawgr")
    public suspend fun systemEvents(vararg values: Output<String>) {
        this.systemEvents = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of system events.
     */
    @JvmName("qkxjvgbycxjjrjhl")
    public suspend fun systemEvents(values: List<Output<String>>) {
        this.systemEvents = Output.all(values)
    }

    /**
     * @param value Gets or sets the EventHandler URL template. You can use a predefined parameter {hub} and {event} inside the template, the value of the EventHandler URL is dynamically calculated when the client request comes in.
     * For example, UrlTemplate can be `http://example.com/api/{hub}/{event}`. The host part can't contains parameters.
     */
    @JvmName("fbqtwsixnhydnqtp")
    public suspend fun urlTemplate(`value`: Output<String>) {
        this.urlTemplate = value
    }

    /**
     * @param value Gets or sets the matching pattern for event names.
     * There are 3 kinds of patterns supported:
     *     1. "*", it matches any event name
     *     2. Combine multiple events with ",", for example "event1,event2", it matches event "event1" and "event2"
     *     3. A single event name, for example, "event1", it matches "event1"
     */
    @JvmName("hegdisnhnlrxsqyd")
    public suspend fun userEventPattern(`value`: Output<String>) {
        this.userEventPattern = value
    }

    /**
     * @param value Upstream auth settings. If not set, no auth is used for upstream messages.
     */
    @JvmName("oboxxduhuyvppdgi")
    public suspend fun auth(`value`: UpstreamAuthSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param argument Upstream auth settings. If not set, no auth is used for upstream messages.
     */
    @JvmName("ckayfacpxlyrooag")
    public suspend fun auth(argument: suspend UpstreamAuthSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UpstreamAuthSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param value Gets or sets the list of system events.
     */
    @JvmName("bysiqrjeakvxbkcl")
    public suspend fun systemEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemEvents = mapped
    }

    /**
     * @param values Gets or sets the list of system events.
     */
    @JvmName("rfsecteoofustprr")
    public suspend fun systemEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemEvents = mapped
    }

    /**
     * @param value Gets or sets the EventHandler URL template. You can use a predefined parameter {hub} and {event} inside the template, the value of the EventHandler URL is dynamically calculated when the client request comes in.
     * For example, UrlTemplate can be `http://example.com/api/{hub}/{event}`. The host part can't contains parameters.
     */
    @JvmName("rahlylvcpibdbhmp")
    public suspend fun urlTemplate(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.urlTemplate = mapped
    }

    /**
     * @param value Gets or sets the matching pattern for event names.
     * There are 3 kinds of patterns supported:
     *     1. "*", it matches any event name
     *     2. Combine multiple events with ",", for example "event1,event2", it matches event "event1" and "event2"
     *     3. A single event name, for example, "event1", it matches "event1"
     */
    @JvmName("lsmamvjwyhbdsrgc")
    public suspend fun userEventPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userEventPattern = mapped
    }

    internal fun build(): EventHandlerArgs = EventHandlerArgs(
        auth = auth,
        systemEvents = systemEvents,
        urlTemplate = urlTemplate ?: throw PulumiNullFieldException("urlTemplate"),
        userEventPattern = userEventPattern,
    )
}
