@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.EventHubEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Event Hub endpoint.
 * The managed identity of Web PubSub service must be enabled, and the identity should have the "Azure Event Hubs Data sender" role to access Event Hub.
 * @property eventHubName The name of the Event Hub.
 * @property fullyQualifiedNamespace The fully qualified namespace name of the Event Hub resource. For example, "example.servicebus.windows.net".
 * @property type
 * Expected value is 'EventHub'.
 */
public data class EventHubEndpointArgs(
    public val eventHubName: Output<String>,
    public val fullyQualifiedNamespace: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.EventHubEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.EventHubEndpointArgs =
        com.pulumi.azurenative.webpubsub.inputs.EventHubEndpointArgs.builder()
            .eventHubName(eventHubName.applyValue({ args0 -> args0 }))
            .fullyQualifiedNamespace(fullyQualifiedNamespace.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventHubEndpointArgs].
 */
@PulumiTagMarker
public class EventHubEndpointArgsBuilder internal constructor() {
    private var eventHubName: Output<String>? = null

    private var fullyQualifiedNamespace: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the Event Hub.
     */
    @JvmName("wrxpsiscxmmjeyrn")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value The fully qualified namespace name of the Event Hub resource. For example, "example.servicebus.windows.net".
     */
    @JvmName("fbiovuhidlflbmim")
    public suspend fun fullyQualifiedNamespace(`value`: Output<String>) {
        this.fullyQualifiedNamespace = value
    }

    /**
     * @param value
     * Expected value is 'EventHub'.
     */
    @JvmName("wvxkqatmlgqksevn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the Event Hub.
     */
    @JvmName("yehdvvfkiyjquypd")
    public suspend fun eventHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value The fully qualified namespace name of the Event Hub resource. For example, "example.servicebus.windows.net".
     */
    @JvmName("ytbjumjqhufgrbxl")
    public suspend fun fullyQualifiedNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fullyQualifiedNamespace = mapped
    }

    /**
     * @param value
     * Expected value is 'EventHub'.
     */
    @JvmName("sdrttibdlprdjemo")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EventHubEndpointArgs = EventHubEndpointArgs(
        eventHubName = eventHubName ?: throw PulumiNullFieldException("eventHubName"),
        fullyQualifiedNamespace = fullyQualifiedNamespace ?: throw
            PulumiNullFieldException("fullyQualifiedNamespace"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
