@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.EventNameFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Filter events by their name.
 * @property systemEvents Gets or sets a list of system events. Supported events: "connected" and "disconnected". Blocking event "connect" is not supported because it requires a response.
 * @property type
 * Expected value is 'EventName'.
 * @property userEventPattern Gets or sets a matching pattern for event names.
 * There are 3 kinds of patterns supported:
 *     1. "*", it matches any event name
 *     2. Combine multiple events with ",", for example "event1,event2", it matches events "event1" and "event2"
 *     3. A single event name, for example, "event1", it matches "event1"
 */
public data class EventNameFilterArgs(
    public val systemEvents: Output<List<String>>? = null,
    public val type: Output<String>,
    public val userEventPattern: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.EventNameFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.EventNameFilterArgs =
        com.pulumi.azurenative.webpubsub.inputs.EventNameFilterArgs.builder()
            .systemEvents(systemEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .userEventPattern(userEventPattern?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventNameFilterArgs].
 */
@PulumiTagMarker
public class EventNameFilterArgsBuilder internal constructor() {
    private var systemEvents: Output<List<String>>? = null

    private var type: Output<String>? = null

    private var userEventPattern: Output<String>? = null

    /**
     * @param value Gets or sets a list of system events. Supported events: "connected" and "disconnected". Blocking event "connect" is not supported because it requires a response.
     */
    @JvmName("fwbhgcqyyfttvpdh")
    public suspend fun systemEvents(`value`: Output<List<String>>) {
        this.systemEvents = value
    }

    @JvmName("njglaxnkqyxcmnmt")
    public suspend fun systemEvents(vararg values: Output<String>) {
        this.systemEvents = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets a list of system events. Supported events: "connected" and "disconnected". Blocking event "connect" is not supported because it requires a response.
     */
    @JvmName("mesowqnipaskybbv")
    public suspend fun systemEvents(values: List<Output<String>>) {
        this.systemEvents = Output.all(values)
    }

    /**
     * @param value
     * Expected value is 'EventName'.
     */
    @JvmName("iqhwuyvrupbmyvex")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets a matching pattern for event names.
     * There are 3 kinds of patterns supported:
     *     1. "*", it matches any event name
     *     2. Combine multiple events with ",", for example "event1,event2", it matches events "event1" and "event2"
     *     3. A single event name, for example, "event1", it matches "event1"
     */
    @JvmName("yoegbockpcrmvnjy")
    public suspend fun userEventPattern(`value`: Output<String>) {
        this.userEventPattern = value
    }

    /**
     * @param value Gets or sets a list of system events. Supported events: "connected" and "disconnected". Blocking event "connect" is not supported because it requires a response.
     */
    @JvmName("vpoftnyemojawprp")
    public suspend fun systemEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemEvents = mapped
    }

    /**
     * @param values Gets or sets a list of system events. Supported events: "connected" and "disconnected". Blocking event "connect" is not supported because it requires a response.
     */
    @JvmName("ptnxsmsjpsckerbp")
    public suspend fun systemEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.systemEvents = mapped
    }

    /**
     * @param value
     * Expected value is 'EventName'.
     */
    @JvmName("wififfuvkbbotwrs")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets a matching pattern for event names.
     * There are 3 kinds of patterns supported:
     *     1. "*", it matches any event name
     *     2. Combine multiple events with ",", for example "event1,event2", it matches events "event1" and "event2"
     *     3. A single event name, for example, "event1", it matches "event1"
     */
    @JvmName("oqtyokyiratirkyc")
    public suspend fun userEventPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userEventPattern = mapped
    }

    internal fun build(): EventNameFilterArgs = EventNameFilterArgs(
        systemEvents = systemEvents,
        type = type ?: throw PulumiNullFieldException("type"),
        userEventPattern = userEventPattern,
    )
}
