@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.ResourceLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource log configuration of a Microsoft.SignalRService resource.
 * @property categories Gets or sets the list of category configurations.
 */
public data class ResourceLogConfigurationArgs(
    public val categories: Output<List<ResourceLogCategoryArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.ResourceLogConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.ResourceLogConfigurationArgs =
        com.pulumi.azurenative.webpubsub.inputs.ResourceLogConfigurationArgs.builder()
            .categories(
                categories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceLogConfigurationArgs].
 */
@PulumiTagMarker
public class ResourceLogConfigurationArgsBuilder internal constructor() {
    private var categories: Output<List<ResourceLogCategoryArgs>>? = null

    /**
     * @param value Gets or sets the list of category configurations.
     */
    @JvmName("bdgrmjqsvwkpavxv")
    public suspend fun categories(`value`: Output<List<ResourceLogCategoryArgs>>) {
        this.categories = value
    }

    @JvmName("kyyfytonorjjrcwt")
    public suspend fun categories(vararg values: Output<ResourceLogCategoryArgs>) {
        this.categories = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of category configurations.
     */
    @JvmName("bnmxtygfyaaajfel")
    public suspend fun categories(values: List<Output<ResourceLogCategoryArgs>>) {
        this.categories = Output.all(values)
    }

    /**
     * @param value Gets or sets the list of category configurations.
     */
    @JvmName("gbsebuoummmollam")
    public suspend fun categories(`value`: List<ResourceLogCategoryArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    /**
     * @param argument Gets or sets the list of category configurations.
     */
    @JvmName("lwwglodkcmtfmryw")
    public suspend fun categories(argument: List<suspend ResourceLogCategoryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceLogCategoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param argument Gets or sets the list of category configurations.
     */
    @JvmName("cpomokakcsvglffl")
    public suspend fun categories(
        vararg
        argument: suspend ResourceLogCategoryArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceLogCategoryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param argument Gets or sets the list of category configurations.
     */
    @JvmName("fedisrctrvquybhi")
    public suspend fun categories(argument: suspend ResourceLogCategoryArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceLogCategoryArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.categories = mapped
    }

    /**
     * @param values Gets or sets the list of category configurations.
     */
    @JvmName("vjehljoiwvwjfyqt")
    public suspend fun categories(vararg values: ResourceLogCategoryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.categories = mapped
    }

    internal fun build(): ResourceLogConfigurationArgs = ResourceLogConfigurationArgs(
        categories = categories,
    )
}
