@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.inputs

import com.pulumi.azurenative.webpubsub.inputs.ResourceReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reference to a resource.
 * @property id Resource ID.
 */
public data class ResourceReferenceArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.webpubsub.inputs.ResourceReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.webpubsub.inputs.ResourceReferenceArgs =
        com.pulumi.azurenative.webpubsub.inputs.ResourceReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceReferenceArgs].
 */
@PulumiTagMarker
public class ResourceReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("romaturegijdrrrt")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("sfxejwjgjtbgxehb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ResourceReferenceArgs = ResourceReferenceArgs(
        id = id,
    )
}
