@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of event handler.
 * @property auth Upstream auth settings. If not set, no auth is used for upstream messages.
 * @property systemEvents Gets or sets the list of system events.
 * @property urlTemplate Gets or sets the EventHandler URL template. You can use a predefined parameter {hub} and {event} inside the template, the value of the EventHandler URL is dynamically calculated when the client request comes in.
 * For example, UrlTemplate can be `http://example.com/api/{hub}/{event}`. The host part can't contains parameters.
 * @property userEventPattern Gets or sets the matching pattern for event names.
 * There are 3 kinds of patterns supported:
 *     1. "*", it matches any event name
 *     2. Combine multiple events with ",", for example "event1,event2", it matches event "event1" and "event2"
 *     3. A single event name, for example, "event1", it matches "event1"
 */
public data class EventHandlerResponse(
    public val auth: UpstreamAuthSettingsResponse? = null,
    public val systemEvents: List<String>? = null,
    public val urlTemplate: String,
    public val userEventPattern: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.EventHandlerResponse):
            EventHandlerResponse = EventHandlerResponse(
            auth = javaType.auth().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.webpubsub.kotlin.outputs.UpstreamAuthSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemEvents = javaType.systemEvents().map({ args0 -> args0 }),
            urlTemplate = javaType.urlTemplate(),
            userEventPattern = javaType.userEventPattern().map({ args0 -> args0 }).orElse(null),
        )
    }
}
