@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.Suppress

/**
 * A setting defines which kinds of events should be sent to which endpoint.
 * @property endpoint An endpoint specifying where Web PubSub should send events to.
 * @property filter A base class for event filter which determines whether an event should be sent to an event listener.
 */
public data class EventListenerResponse(
    public val endpoint: EventHubEndpointResponse,
    public val filter: EventNameFilterResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.EventListenerResponse):
            EventListenerResponse = EventListenerResponse(
            endpoint = javaType.endpoint().let({ args0 ->
                com.pulumi.azurenative.webpubsub.kotlin.outputs.EventHubEndpointResponse.Companion.toKotlin(args0)
            }),
            filter = javaType.filter().let({ args0 ->
                com.pulumi.azurenative.webpubsub.kotlin.outputs.EventNameFilterResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
