@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.webpubsub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A hub setting
 * @property id Fully qualified resource Id for the resource.
 * @property name The name of the resource.
 * @property properties Properties of a hub.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource - e.g. "Microsoft.SignalRService/SignalR"
 */
public data class GetWebPubSubHubResult(
    public val id: String,
    public val name: String,
    public val properties: WebPubSubHubPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.webpubsub.outputs.GetWebPubSubHubResult):
            GetWebPubSubHubResult = GetWebPubSubHubResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.webpubsub.kotlin.outputs.WebPubSubHubPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.webpubsub.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
