@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin

import com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse.Companion.toKotlin as managedRGConfigurationResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SAPVirtualInstanceErrorResponse.Companion.toKotlin as sAPVirtualInstanceErrorResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse.Companion.toKotlin as userAssignedServiceIdentityResponseToKotlin

/**
 * Builder for [SAPVirtualInstance].
 */
@PulumiTagMarker
public class SAPVirtualInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SAPVirtualInstanceArgs = SAPVirtualInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SAPVirtualInstanceArgsBuilder.() -> Unit) {
        val builder = SAPVirtualInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SAPVirtualInstance {
        val builtJavaResource =
            com.pulumi.azurenative.workloads.SAPVirtualInstance(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SAPVirtualInstance(builtJavaResource)
    }
}

/**
 * Define the Virtual Instance for SAP solutions resource.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### Create Infrastructure (with OS configuration) with custom resource names for Distributed System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 CustomResourceNames = new AzureNative.Workloads.Inputs.ThreeTierFullResourceNamesArgs
 *                 {
 *                     ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerFullResourceNamesArgs
 *                     {
 *                         AvailabilitySetName = "appAvSet",
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app0disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName0",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic0",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app0osdisk",
 *                                 VmName = "appvm0",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app1disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName1",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic1",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app1osdisk",
 *                                 VmName = "appvm1",
 *                             },
 *                         },
 *                     },
 *                     CentralServer = new AzureNative.Workloads.Inputs.CentralServerFullResourceNamesArgs
 *                     {
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "ascsdisk0",
 *                                     } },
 *                                 },
 *                                 HostName = "ascshostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ascsnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ascsosdisk",
 *                                 VmName = "ascsvm",
 *                             },
 *                         },
 *                     },
 *                     DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseServerFullResourceNamesArgs
 *                     {
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadata0",
 *                                         "hanadata1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalog0",
 *                                         "hanalog1",
 *                                         "hanalog2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanashared0",
 *                                         "hanashared1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsap0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbosdisk",
 *                                 VmName = "dbvm",
 *                             },
 *                         },
 *                     },
 *                     NamingPatternType = "FullResourceName",
 *                     SharedStorage = new AzureNative.Workloads.Inputs.SharedStorageResourceNamesArgs
 *                     {
 *                         SharedStorageAccountName = "storageacc",
 *                         SharedStorageAccountPrivateEndPointName = "peForxNFS",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					CustomResourceNames: workloads.ThreeTierFullResourceNames{
 * 						ApplicationServer: workloads.ApplicationServerFullResourceNames{
 * 							AvailabilitySetName: "appAvSet",
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app0disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName0",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic0",
 * 										},
 * 									},
 * 									OsDiskName: "app0osdisk",
 * 									VmName:     "appvm0",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app1disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName1",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic1",
 * 										},
 * 									},
 * 									OsDiskName: "app1osdisk",
 * 									VmName:     "appvm1",
 * 								},
 * 							},
 * 						},
 * 						CentralServer: workloads.CentralServerFullResourceNames{
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"ascsdisk0",
 * 										},
 * 									},
 * 									HostName: "ascshostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ascsnic",
 * 										},
 * 									},
 * 									OsDiskName: "ascsosdisk",
 * 									VmName:     "ascsvm",
 * 								},
 * 							},
 * 						},
 * 						DatabaseServer: workloads.DatabaseServerFullResourceNames{
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadata0",
 * 											"hanadata1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalog0",
 * 											"hanalog1",
 * 											"hanalog2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanashared0",
 * 											"hanashared1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsap0",
 * 										},
 * 									},
 * 									HostName: "dbhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbosdisk",
 * 									VmName:     "dbvm",
 * 								},
 * 							},
 * 						},
 * 						NamingPatternType: "FullResourceName",
 * 						SharedStorage: workloads.SharedStorageResourceNames{
 * 							SharedStorageAccountName:                "storageacc",
 * 							SharedStorageAccountPrivateEndPointName: "peForxNFS",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("customResourceNames", Map.ofEntries(
 *                         Map.entry("applicationServer", Map.ofEntries(
 *                             Map.entry("availabilitySetName", "appAvSet"),
 *                             Map.entry("virtualMachines",
 *                                 Map.ofEntries(
 *                                     Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                         .default_("app0disk0")
 *                                         .build()),
 *                                     Map.entry("hostName", "apphostName0"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "appnic0")),
 *                                     Map.entry("osDiskName", "app0osdisk"),
 *                                     Map.entry("vmName", "appvm0")
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                         .default_("app1disk0")
 *                                         .build()),
 *                                     Map.entry("hostName", "apphostName1"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "appnic1")),
 *                                     Map.entry("osDiskName", "app1osdisk"),
 *                                     Map.entry("vmName", "appvm1")
 *                                 ))
 *                         )),
 *                         Map.entry("centralServer", Map.of("virtualMachines", Map.ofEntries(
 *                             Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                 .default_("ascsdisk0")
 *                                 .build()),
 *                             Map.entry("hostName", "ascshostName"),
 *                             Map.entry("networkInterfaces", Map.of("networkInterfaceName", "ascsnic")),
 *                             Map.entry("osDiskName", "ascsosdisk"),
 *                             Map.entry("vmName", "ascsvm")
 *                         ))),
 *                         Map.entry("databaseServer", Map.of("virtualMachines", Map.ofEntries(
 *                             Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                 .hanaData(
 *                                     "hanadata0",
 *                                     "hanadata1")
 *                                 .hanaLog(
 *                                     "hanalog0",
 *                                     "hanalog1",
 *                                     "hanalog2")
 *                                 .hanaShared(
 *                                     "hanashared0",
 *                                     "hanashared1")
 *                                 .usrSap("usrsap0")
 *                                 .build()),
 *                             Map.entry("hostName", "dbhostName"),
 *                             Map.entry("networkInterfaces", Map.of("networkInterfaceName", "dbnic")),
 *                             Map.entry("osDiskName", "dbosdisk"),
 *                             Map.entry("vmName", "dbvm")
 *                         ))),
 *                         Map.entry("namingPatternType", "FullResourceName"),
 *                         Map.entry("sharedStorage", Map.ofEntries(
 *                             Map.entry("sharedStorageAccountName", "storageacc"),
 *                             Map.entry("sharedStorageAccountPrivateEndPointName", "peForxNFS")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier")
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure (with OS configuration) with custom resource names for HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 CustomResourceNames = new AzureNative.Workloads.Inputs.ThreeTierFullResourceNamesArgs
 *                 {
 *                     ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerFullResourceNamesArgs
 *                     {
 *                         AvailabilitySetName = "appAvSet",
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app0disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName0",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic0",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app0osdisk",
 *                                 VmName = "appvm0",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app1disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName1",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic1",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app1osdisk",
 *                                 VmName = "appvm1",
 *                             },
 *                         },
 *                     },
 *                     CentralServer = new AzureNative.Workloads.Inputs.CentralServerFullResourceNamesArgs
 *                     {
 *                         AvailabilitySetName = "csAvSet",
 *                         LoadBalancer = new AzureNative.Workloads.Inputs.LoadBalancerResourceNamesArgs
 *                         {
 *                             BackendPoolNames = new[]
 *                             {
 *                                 "ascsBackendPool",
 *                             },
 *                             FrontendIpConfigurationNames = new[]
 *                             {
 *                                 "ascsip0",
 *                                 "ersip0",
 *                             },
 *                             HealthProbeNames = new[]
 *                             {
 *                                 "ascsHealthProbe",
 *                                 "ersHealthProbe",
 *                             },
 *                             LoadBalancerName = "ascslb",
 *                         },
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 HostName = "ascshostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ascsnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ascsosdisk",
 *                                 VmName = "ascsvm",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 HostName = "ershostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ersnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ersosdisk",
 *                                 VmName = "ersvm",
 *                             },
 *                         },
 *                     },
 *                     DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseServerFullResourceNamesArgs
 *                     {
 *                         AvailabilitySetName = "dbAvSet",
 *                         LoadBalancer = new AzureNative.Workloads.Inputs.LoadBalancerResourceNamesArgs
 *                         {
 *                             BackendPoolNames = new[]
 *                             {
 *                                 "dbBackendPool",
 *                             },
 *                             FrontendIpConfigurationNames = new[]
 *                             {
 *                                 "dbip",
 *                             },
 *                             HealthProbeNames = new[]
 *                             {
 *                                 "dbHealthProbe",
 *                             },
 *                             LoadBalancerName = "dblb",
 *                         },
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadatapr0",
 *                                         "hanadatapr1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalogpr0",
 *                                         "hanalogpr1",
 *                                         "hanalogpr2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanasharedpr0",
 *                                         "hanasharedpr1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsappr0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbprhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbprnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbprosdisk",
 *                                 VmName = "dbvmpr",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadatasr0",
 *                                         "hanadatasr1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalogsr0",
 *                                         "hanalogsr1",
 *                                         "hanalogsr2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanasharedsr0",
 *                                         "hanasharedsr1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsapsr0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbsrhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbsrnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbsrosdisk",
 *                                 VmName = "dbvmsr",
 *                             },
 *                         },
 *                     },
 *                     NamingPatternType = "FullResourceName",
 *                     SharedStorage = new AzureNative.Workloads.Inputs.SharedStorageResourceNamesArgs
 *                     {
 *                         SharedStorageAccountName = "storageacc",
 *                         SharedStorageAccountPrivateEndPointName = "peForxNFS",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilitySet",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					CustomResourceNames: workloads.ThreeTierFullResourceNames{
 * 						ApplicationServer: workloads.ApplicationServerFullResourceNames{
 * 							AvailabilitySetName: "appAvSet",
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app0disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName0",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic0",
 * 										},
 * 									},
 * 									OsDiskName: "app0osdisk",
 * 									VmName:     "appvm0",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app1disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName1",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic1",
 * 										},
 * 									},
 * 									OsDiskName: "app1osdisk",
 * 									VmName:     "appvm1",
 * 								},
 * 							},
 * 						},
 * 						CentralServer: workloads.CentralServerFullResourceNames{
 * 							AvailabilitySetName: "csAvSet",
 * 							LoadBalancer: workloads.LoadBalancerResourceNames{
 * 								BackendPoolNames: []string{
 * 									"ascsBackendPool",
 * 								},
 * 								FrontendIpConfigurationNames: []string{
 * 									"ascsip0",
 * 									"ersip0",
 * 								},
 * 								HealthProbeNames: []string{
 * 									"ascsHealthProbe",
 * 									"ersHealthProbe",
 * 								},
 * 								LoadBalancerName: "ascslb",
 * 							},
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									HostName: "ascshostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ascsnic",
 * 										},
 * 									},
 * 									OsDiskName: "ascsosdisk",
 * 									VmName:     "ascsvm",
 * 								},
 * 								{
 * 									HostName: "ershostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ersnic",
 * 										},
 * 									},
 * 									OsDiskName: "ersosdisk",
 * 									VmName:     "ersvm",
 * 								},
 * 							},
 * 						},
 * 						DatabaseServer: workloads.DatabaseServerFullResourceNames{
 * 							AvailabilitySetName: "dbAvSet",
 * 							LoadBalancer: workloads.LoadBalancerResourceNames{
 * 								BackendPoolNames: []string{
 * 									"dbBackendPool",
 * 								},
 * 								FrontendIpConfigurationNames: []string{
 * 									"dbip",
 * 								},
 * 								HealthProbeNames: []string{
 * 									"dbHealthProbe",
 * 								},
 * 								LoadBalancerName: "dblb",
 * 							},
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadatapr0",
 * 											"hanadatapr1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalogpr0",
 * 											"hanalogpr1",
 * 											"hanalogpr2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanasharedpr0",
 * 											"hanasharedpr1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsappr0",
 * 										},
 * 									},
 * 									HostName: "dbprhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbprnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbprosdisk",
 * 									VmName:     "dbvmpr",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadatasr0",
 * 											"hanadatasr1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalogsr0",
 * 											"hanalogsr1",
 * 											"hanalogsr2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanasharedsr0",
 * 											"hanasharedsr1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsapsr0",
 * 										},
 * 									},
 * 									HostName: "dbsrhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbsrnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbsrosdisk",
 * 									VmName:     "dbvmsr",
 * 								},
 * 							},
 * 						},
 * 						NamingPatternType: "FullResourceName",
 * 						SharedStorage: workloads.SharedStorageResourceNames{
 * 							SharedStorageAccountName:                "storageacc",
 * 							SharedStorageAccountPrivateEndPointName: "peForxNFS",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: "AvailabilitySet",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("customResourceNames", Map.ofEntries(
 *                         Map.entry("applicationServer", Map.ofEntries(
 *                             Map.entry("availabilitySetName", "appAvSet"),
 *                             Map.entry("virtualMachines",
 *                                 Map.ofEntries(
 *                                     Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                         .default_("app0disk0")
 *                                         .build()),
 *                                     Map.entry("hostName", "apphostName0"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "appnic0")),
 *                                     Map.entry("osDiskName", "app0osdisk"),
 *                                     Map.entry("vmName", "appvm0")
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                         .default_("app1disk0")
 *                                         .build()),
 *                                     Map.entry("hostName", "apphostName1"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "appnic1")),
 *                                     Map.entry("osDiskName", "app1osdisk"),
 *                                     Map.entry("vmName", "appvm1")
 *                                 ))
 *                         )),
 *                         Map.entry("centralServer", Map.ofEntries(
 *                             Map.entry("availabilitySetName", "csAvSet"),
 *                             Map.entry("loadBalancer", Map.ofEntries(
 *                                 Map.entry("backendPoolNames", "ascsBackendPool"),
 *                                 Map.entry("frontendIpConfigurationNames",
 *                                     "ascsip0",
 *                                     "ersip0"),
 *                                 Map.entry("healthProbeNames",
 *                                     "ascsHealthProbe",
 *                                     "ersHealthProbe"),
 *                                 Map.entry("loadBalancerName", "ascslb")
 *                             )),
 *                             Map.entry("virtualMachines",
 *                                 Map.ofEntries(
 *                                     Map.entry("hostName", "ascshostName"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "ascsnic")),
 *                                     Map.entry("osDiskName", "ascsosdisk"),
 *                                     Map.entry("vmName", "ascsvm")
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("hostName", "ershostName"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "ersnic")),
 *                                     Map.entry("osDiskName", "ersosdisk"),
 *                                     Map.entry("vmName", "ersvm")
 *                                 ))
 *                         )),
 *                         Map.entry("databaseServer", Map.ofEntries(
 *                             Map.entry("availabilitySetName", "dbAvSet"),
 *                             Map.entry("loadBalancer", Map.ofEntries(
 *                                 Map.entry("backendPoolNames", "dbBackendPool"),
 *                                 Map.entry("frontendIpConfigurationNames", "dbip"),
 *                                 Map.entry("healthProbeNames", "dbHealthProbe"),
 *                                 Map.entry("loadBalancerName", "dblb")
 *                             )),
 *                             Map.entry("virtualMachines",
 *                                 Map.ofEntries(
 *                                     Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                         .hanaData(
 *                                             "hanadatapr0",
 *                                             "hanadatapr1")
 *                                         .hanaLog(
 *                                             "hanalogpr0",
 *                                             "hanalogpr1",
 *                                             "hanalogpr2")
 *                                         .hanaShared(
 *                                             "hanasharedpr0",
 *                                             "hanasharedpr1")
 *                                         .usrSap("usrsappr0")
 *                                         .build()),
 *                                     Map.entry("hostName", "dbprhostName"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "dbprnic")),
 *                                     Map.entry("osDiskName", "dbprosdisk"),
 *                                     Map.entry("vmName", "dbvmpr")
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                         .hanaData(
 *                                             "hanadatasr0",
 *                                             "hanadatasr1")
 *                                         .hanaLog(
 *                                             "hanalogsr0",
 *                                             "hanalogsr1",
 *                                             "hanalogsr2")
 *                                         .hanaShared(
 *                                             "hanasharedsr0",
 *                                             "hanasharedsr1")
 *                                         .usrSap("usrsapsr0")
 *                                         .build()),
 *                                     Map.entry("hostName", "dbsrhostName"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "dbsrnic")),
 *                                     Map.entry("osDiskName", "dbsrosdisk"),
 *                                     Map.entry("vmName", "dbvmsr")
 *                                 ))
 *                         )),
 *                         Map.entry("namingPatternType", "FullResourceName"),
 *                         Map.entry("sharedStorage", Map.ofEntries(
 *                             Map.entry("sharedStorageAccountName", "storageacc"),
 *                             Map.entry("sharedStorageAccountPrivateEndPointName", "peForxNFS")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilitySet"))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure (with OS configuration) with custom resource names for HA system with Availability Zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 CustomResourceNames = new AzureNative.Workloads.Inputs.ThreeTierFullResourceNamesArgs
 *                 {
 *                     ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerFullResourceNamesArgs
 *                     {
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app0disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName0",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic0",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app0osdisk",
 *                                 VmName = "appvm0",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "default", new[]
 *                                     {
 *                                         "app1disk0",
 *                                     } },
 *                                 },
 *                                 HostName = "apphostName1",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "appnic1",
 *                                     },
 *                                 },
 *                                 OsDiskName = "app1osdisk",
 *                                 VmName = "appvm1",
 *                             },
 *                         },
 *                     },
 *                     CentralServer = new AzureNative.Workloads.Inputs.CentralServerFullResourceNamesArgs
 *                     {
 *                         LoadBalancer = new AzureNative.Workloads.Inputs.LoadBalancerResourceNamesArgs
 *                         {
 *                             BackendPoolNames = new[]
 *                             {
 *                                 "ascsBackendPool",
 *                             },
 *                             FrontendIpConfigurationNames = new[]
 *                             {
 *                                 "ascsip0",
 *                                 "ersip0",
 *                             },
 *                             HealthProbeNames = new[]
 *                             {
 *                                 "ascsHealthProbe",
 *                                 "ersHealthProbe",
 *                             },
 *                             LoadBalancerName = "ascslb",
 *                         },
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 HostName = "ascshostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ascsnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ascsosdisk",
 *                                 VmName = "ascsvm",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 HostName = "ershostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "ersnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "ersosdisk",
 *                                 VmName = "ersvm",
 *                             },
 *                         },
 *                     },
 *                     DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseServerFullResourceNamesArgs
 *                     {
 *                         LoadBalancer = new AzureNative.Workloads.Inputs.LoadBalancerResourceNamesArgs
 *                         {
 *                             BackendPoolNames = new[]
 *                             {
 *                                 "dbBackendPool",
 *                             },
 *                             FrontendIpConfigurationNames = new[]
 *                             {
 *                                 "dbip",
 *                             },
 *                             HealthProbeNames = new[]
 *                             {
 *                                 "dbHealthProbe",
 *                             },
 *                             LoadBalancerName = "dblb",
 *                         },
 *                         VirtualMachines = new[]
 *                         {
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadatapr0",
 *                                         "hanadatapr1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalogpr0",
 *                                         "hanalogpr1",
 *                                         "hanalogpr2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanasharedpr0",
 *                                         "hanasharedpr1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsappr0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbprhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbprnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbprosdisk",
 *                                 VmName = "dbvmpr",
 *                             },
 *                             new AzureNative.Workloads.Inputs.VirtualMachineResourceNamesArgs
 *                             {
 *                                 DataDiskNames =
 *                                 {
 *                                     { "hanaData", new[]
 *                                     {
 *                                         "hanadatasr0",
 *                                         "hanadatasr1",
 *                                     } },
 *                                     { "hanaLog", new[]
 *                                     {
 *                                         "hanalogsr0",
 *                                         "hanalogsr1",
 *                                         "hanalogsr2",
 *                                     } },
 *                                     { "hanaShared", new[]
 *                                     {
 *                                         "hanasharedsr0",
 *                                         "hanasharedsr1",
 *                                     } },
 *                                     { "usrSap", new[]
 *                                     {
 *                                         "usrsapsr0",
 *                                     } },
 *                                 },
 *                                 HostName = "dbsrhostName",
 *                                 NetworkInterfaces = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.NetworkInterfaceResourceNamesArgs
 *                                     {
 *                                         NetworkInterfaceName = "dbsrnic",
 *                                     },
 *                                 },
 *                                 OsDiskName = "dbsrosdisk",
 *                                 VmName = "dbvmsr",
 *                             },
 *                         },
 *                     },
 *                     NamingPatternType = "FullResourceName",
 *                     SharedStorage = new AzureNative.Workloads.Inputs.SharedStorageResourceNamesArgs
 *                     {
 *                         SharedStorageAccountName = "storageacc",
 *                         SharedStorageAccountPrivateEndPointName = "peForxNFS",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilityZone",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					CustomResourceNames: workloads.ThreeTierFullResourceNames{
 * 						ApplicationServer: workloads.ApplicationServerFullResourceNames{
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app0disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName0",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic0",
 * 										},
 * 									},
 * 									OsDiskName: "app0osdisk",
 * 									VmName:     "appvm0",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"default": []string{
 * 											"app1disk0",
 * 										},
 * 									},
 * 									HostName: "apphostName1",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "appnic1",
 * 										},
 * 									},
 * 									OsDiskName: "app1osdisk",
 * 									VmName:     "appvm1",
 * 								},
 * 							},
 * 						},
 * 						CentralServer: workloads.CentralServerFullResourceNames{
 * 							LoadBalancer: workloads.LoadBalancerResourceNames{
 * 								BackendPoolNames: []string{
 * 									"ascsBackendPool",
 * 								},
 * 								FrontendIpConfigurationNames: []string{
 * 									"ascsip0",
 * 									"ersip0",
 * 								},
 * 								HealthProbeNames: []string{
 * 									"ascsHealthProbe",
 * 									"ersHealthProbe",
 * 								},
 * 								LoadBalancerName: "ascslb",
 * 							},
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									HostName: "ascshostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ascsnic",
 * 										},
 * 									},
 * 									OsDiskName: "ascsosdisk",
 * 									VmName:     "ascsvm",
 * 								},
 * 								{
 * 									HostName: "ershostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "ersnic",
 * 										},
 * 									},
 * 									OsDiskName: "ersosdisk",
 * 									VmName:     "ersvm",
 * 								},
 * 							},
 * 						},
 * 						DatabaseServer: workloads.DatabaseServerFullResourceNames{
 * 							LoadBalancer: workloads.LoadBalancerResourceNames{
 * 								BackendPoolNames: []string{
 * 									"dbBackendPool",
 * 								},
 * 								FrontendIpConfigurationNames: []string{
 * 									"dbip",
 * 								},
 * 								HealthProbeNames: []string{
 * 									"dbHealthProbe",
 * 								},
 * 								LoadBalancerName: "dblb",
 * 							},
 * 							VirtualMachines: []workloads.VirtualMachineResourceNames{
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadatapr0",
 * 											"hanadatapr1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalogpr0",
 * 											"hanalogpr1",
 * 											"hanalogpr2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanasharedpr0",
 * 											"hanasharedpr1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsappr0",
 * 										},
 * 									},
 * 									HostName: "dbprhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbprnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbprosdisk",
 * 									VmName:     "dbvmpr",
 * 								},
 * 								{
 * 									DataDiskNames: {
 * 										"hanaData": []string{
 * 											"hanadatasr0",
 * 											"hanadatasr1",
 * 										},
 * 										"hanaLog": []string{
 * 											"hanalogsr0",
 * 											"hanalogsr1",
 * 											"hanalogsr2",
 * 										},
 * 										"hanaShared": []string{
 * 											"hanasharedsr0",
 * 											"hanasharedsr1",
 * 										},
 * 										"usrSap": []string{
 * 											"usrsapsr0",
 * 										},
 * 									},
 * 									HostName: "dbsrhostName",
 * 									NetworkInterfaces: []workloads.NetworkInterfaceResourceNames{
 * 										{
 * 											NetworkInterfaceName: "dbsrnic",
 * 										},
 * 									},
 * 									OsDiskName: "dbsrosdisk",
 * 									VmName:     "dbvmsr",
 * 								},
 * 							},
 * 						},
 * 						NamingPatternType: "FullResourceName",
 * 						SharedStorage: workloads.SharedStorageResourceNames{
 * 							SharedStorageAccountName:                "storageacc",
 * 							SharedStorageAccountPrivateEndPointName: "peForxNFS",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: "AvailabilityZone",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("customResourceNames", Map.ofEntries(
 *                         Map.entry("applicationServer", Map.of("virtualMachines",
 *                             Map.ofEntries(
 *                                 Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                     .default_("app0disk0")
 *                                     .build()),
 *                                 Map.entry("hostName", "apphostName0"),
 *                                 Map.entry("networkInterfaces", Map.of("networkInterfaceName", "appnic0")),
 *                                 Map.entry("osDiskName", "app0osdisk"),
 *                                 Map.entry("vmName", "appvm0")
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                     .default_("app1disk0")
 *                                     .build()),
 *                                 Map.entry("hostName", "apphostName1"),
 *                                 Map.entry("networkInterfaces", Map.of("networkInterfaceName", "appnic1")),
 *                                 Map.entry("osDiskName", "app1osdisk"),
 *                                 Map.entry("vmName", "appvm1")
 *                             ))),
 *                         Map.entry("centralServer", Map.ofEntries(
 *                             Map.entry("loadBalancer", Map.ofEntries(
 *                                 Map.entry("backendPoolNames", "ascsBackendPool"),
 *                                 Map.entry("frontendIpConfigurationNames",
 *                                     "ascsip0",
 *                                     "ersip0"),
 *                                 Map.entry("healthProbeNames",
 *                                     "ascsHealthProbe",
 *                                     "ersHealthProbe"),
 *                                 Map.entry("loadBalancerName", "ascslb")
 *                             )),
 *                             Map.entry("virtualMachines",
 *                                 Map.ofEntries(
 *                                     Map.entry("hostName", "ascshostName"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "ascsnic")),
 *                                     Map.entry("osDiskName", "ascsosdisk"),
 *                                     Map.entry("vmName", "ascsvm")
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("hostName", "ershostName"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "ersnic")),
 *                                     Map.entry("osDiskName", "ersosdisk"),
 *                                     Map.entry("vmName", "ersvm")
 *                                 ))
 *                         )),
 *                         Map.entry("databaseServer", Map.ofEntries(
 *                             Map.entry("loadBalancer", Map.ofEntries(
 *                                 Map.entry("backendPoolNames", "dbBackendPool"),
 *                                 Map.entry("frontendIpConfigurationNames", "dbip"),
 *                                 Map.entry("healthProbeNames", "dbHealthProbe"),
 *                                 Map.entry("loadBalancerName", "dblb")
 *                             )),
 *                             Map.entry("virtualMachines",
 *                                 Map.ofEntries(
 *                                     Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                         .hanaData(
 *                                             "hanadatapr0",
 *                                             "hanadatapr1")
 *                                         .hanaLog(
 *                                             "hanalogpr0",
 *                                             "hanalogpr1",
 *                                             "hanalogpr2")
 *                                         .hanaShared(
 *                                             "hanasharedpr0",
 *                                             "hanasharedpr1")
 *                                         .usrSap("usrsappr0")
 *                                         .build()),
 *                                     Map.entry("hostName", "dbprhostName"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "dbprnic")),
 *                                     Map.entry("osDiskName", "dbprosdisk"),
 *                                     Map.entry("vmName", "dbvmpr")
 *                                 ),
 *                                 Map.ofEntries(
 *                                     Map.entry("dataDiskNames", DeploymentConfigurationArgs.builder()
 *                                         .hanaData(
 *                                             "hanadatasr0",
 *                                             "hanadatasr1")
 *                                         .hanaLog(
 *                                             "hanalogsr0",
 *                                             "hanalogsr1",
 *                                             "hanalogsr2")
 *                                         .hanaShared(
 *                                             "hanasharedsr0",
 *                                             "hanasharedsr1")
 *                                         .usrSap("usrsapsr0")
 *                                         .build()),
 *                                     Map.entry("hostName", "dbsrhostName"),
 *                                     Map.entry("networkInterfaces", Map.of("networkInterfaceName", "dbsrnic")),
 *                                     Map.entry("osDiskName", "dbsrosdisk"),
 *                                     Map.entry("vmName", "dbvmsr")
 *                                 ))
 *                         )),
 *                         Map.entry("namingPatternType", "FullResourceName"),
 *                         Map.entry("sharedStorage", Map.ofEntries(
 *                             Map.entry("sharedStorageAccountName", "storageacc"),
 *                             Map.entry("sharedStorageAccountPrivateEndPointName", "peForxNFS")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilityZone"))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure (with OS configuration) with custom resource names for Single Server System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = "HANA",
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "xyz",
 *                                 PublicKey = "abc",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "NonProd",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					DatabaseType:     "HANA",
 * 					DeploymentType:   "SingleServer",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 					SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "RHEL-SAP",
 * 							Publisher: "RedHat",
 * 							Sku:       "84sapha-gen2",
 * 							Version:   "latest",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "{your-username}",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								SshKeyPair: workloads.SshKeyPair{
 * 									PrivateKey: "xyz",
 * 									PublicKey:  "abc",
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("NonProd"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("databaseType", "HANA"),
 *                     Map.entry("deploymentType", "SingleServer"),
 *                     Map.entry("networkConfiguration", Map.of("isSecondaryIpEnabled", true)),
 *                     Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                     Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                         Map.entry("imageReference", Map.ofEntries(
 *                             Map.entry("offer", "RHEL-SAP"),
 *                             Map.entry("publisher", "RedHat"),
 *                             Map.entry("sku", "84sapha-gen2"),
 *                             Map.entry("version", "latest")
 *                         )),
 *                         Map.entry("osProfile", Map.ofEntries(
 *                             Map.entry("adminUsername", "{your-username}"),
 *                             Map.entry("osConfiguration", Map.ofEntries(
 *                                 Map.entry("disablePasswordAuthentication", true),
 *                                 Map.entry("osType", "Linux"),
 *                                 Map.entry("sshKeyPair", Map.ofEntries(
 *                                     Map.entry("privateKey", "xyz"),
 *                                     Map.entry("publicKey", "abc")
 *                                 ))
 *                             ))
 *                         )),
 *                         Map.entry("vmSize", "Standard_E32ds_v4")
 *                     ))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure only for Distributed System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "Deployment",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "Deployment",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "Deployment"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier")
 *                 ))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure only for HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "Deployment",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 5,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilitySet",
 *                 },
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "Deployment",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 5,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: "AvailabilitySet",
 * 					},
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "Deployment"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 5),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilitySet"))
 *                 ))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure only for HA System with Availability Zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "Deployment",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             KeyData = "ssh-rsa public key",
 *                                         },
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilityZone",
 *                 },
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "Deployment",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									Ssh: workloads.SshConfiguration{
 * 										PublicKeys: []workloads.SshPublicKey{
 * 											{
 * 												KeyData: "ssh-rsa public key",
 * 											},
 * 										},
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: "AvailabilityZone",
 * 					},
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "Deployment"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilityZone"))
 *                 ))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure only for Single Server System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "Deployment",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = "HANA",
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             Ssh = new AzureNative.Workloads.Inputs.SshConfigurationArgs
 *                             {
 *                                 PublicKeys = new[]
 *                                 {
 *                                     new AzureNative.Workloads.Inputs.SshPublicKeyArgs
 *                                     {
 *                                         KeyData = "ssh-rsa public key",
 *                                     },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *         },
 *         Environment = "NonProd",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "Deployment",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					DatabaseType:     "HANA",
 * 					DeploymentType:   "SingleServer",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 					SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "RHEL-SAP",
 * 							Publisher: "RedHat",
 * 							Sku:       "84sapha-gen2",
 * 							Version:   "latest",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "{your-username}",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								Ssh: workloads.SshConfiguration{
 * 									PublicKeys: []workloads.SshPublicKey{
 * 										{
 * 											KeyData: "ssh-rsa public key",
 * 										},
 * 									},
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 			},
 * 			Environment:            pulumi.String("NonProd"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "Deployment"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("databaseType", "HANA"),
 *                     Map.entry("deploymentType", "SingleServer"),
 *                     Map.entry("networkConfiguration", Map.of("isSecondaryIpEnabled", true)),
 *                     Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                     Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                         Map.entry("imageReference", Map.ofEntries(
 *                             Map.entry("offer", "RHEL-SAP"),
 *                             Map.entry("publisher", "RedHat"),
 *                             Map.entry("sku", "84sapha-gen2"),
 *                             Map.entry("version", "latest")
 *                         )),
 *                         Map.entry("osProfile", Map.ofEntries(
 *                             Map.entry("adminUsername", "{your-username}"),
 *                             Map.entry("osConfiguration", Map.ofEntries(
 *                                 Map.entry("disablePasswordAuthentication", true),
 *                                 Map.entry("osType", "Linux"),
 *                                 Map.entry("ssh", Map.of("publicKeys", Map.of("keyData", "ssh-rsa public key")))
 *                             ))
 *                         )),
 *                         Map.entry("vmSize", "Standard_E32ds_v4")
 *                     ))
 *                 ))
 *             ))
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with Disk and OS configuration for Distributed System (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     DiskConfiguration = new AzureNative.Workloads.Inputs.DiskConfigurationArgs
 *                     {
 *                         DiskVolumeConfigurations =
 *                         {
 *                             { "backup", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 2,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "hana/data", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 4,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                             { "hana/log", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 3,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                             { "hana/shared", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "os", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 64,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "usr/sap", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                         },
 *                     },
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * Configuration: workloads.DeploymentWithOSConfiguration{
 * AppLocation: "eastus",
 * ConfigurationType: "DeploymentWithOSConfig",
 * InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * AppResourceGroup: "X00-RG",
 * ApplicationServer: workloads.ApplicationServerConfiguration{
 * InstanceCount: 6,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E32ds_v4",
 * },
 * },
 * CentralServer: workloads.CentralServerConfiguration{
 * InstanceCount: 1,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E16ds_v4",
 * },
 * },
 * DatabaseServer: workloads.DatabaseConfiguration{
 * DatabaseType: "HANA",
 * DiskConfiguration: workloads.DiskConfiguration{
 * DiskVolumeConfigurations: interface{}{
 * Backup: workloads.DiskVolumeConfiguration{
 * Count: 2,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Hana/data: workloads.DiskVolumeConfiguration{
 * Count: 4,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * Hana/log: workloads.DiskVolumeConfiguration{
 * Count: 3,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * Hana/shared: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Os: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 64,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Usr/sap: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * },
 * },
 * InstanceCount: 1,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_M32ts",
 * },
 * },
 * DeploymentType: "ThreeTier",
 * },
 * OsSapConfiguration: workloads.OsSapConfiguration{
 * SapFqdn: "xyz.test.com",
 * },
 * },
 * Environment: pulumi.String("Prod"),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * SapProduct: pulumi.String("S4HANA"),
 * SapVirtualInstanceName: pulumi.String("X00"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("diskConfiguration", Map.of("diskVolumeConfigurations", Map.ofEntries(
 *                             Map.entry("backup", Map.ofEntries(
 *                                 Map.entry("count", 2),
 *                                 Map.entry("sizeGB", 256),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("hana/data", Map.ofEntries(
 *                                 Map.entry("count", 4),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             )),
 *                             Map.entry("hana/log", Map.ofEntries(
 *                                 Map.entry("count", 3),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             )),
 *                             Map.entry("hana/shared", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 256),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("os", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 64),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("usr/sap", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             ))
 *                         ))),
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier")
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with Disk and OS configuration for HA System with Availability Set (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     DiskConfiguration = new AzureNative.Workloads.Inputs.DiskConfigurationArgs
 *                     {
 *                         DiskVolumeConfigurations =
 *                         {
 *                             { "backup", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 2,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "hana/data", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 4,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                             { "hana/log", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 3,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                             { "hana/shared", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "os", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 64,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "usr/sap", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                         },
 *                     },
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilitySet",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * Configuration: workloads.DeploymentWithOSConfiguration{
 * AppLocation: "eastus",
 * ConfigurationType: "DeploymentWithOSConfig",
 * InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * AppResourceGroup: "X00-RG",
 * ApplicationServer: workloads.ApplicationServerConfiguration{
 * InstanceCount: 6,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E32ds_v4",
 * },
 * },
 * CentralServer: workloads.CentralServerConfiguration{
 * InstanceCount: 2,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E16ds_v4",
 * },
 * },
 * DatabaseServer: workloads.DatabaseConfiguration{
 * DatabaseType: "HANA",
 * DiskConfiguration: workloads.DiskConfiguration{
 * DiskVolumeConfigurations: interface{}{
 * Backup: workloads.DiskVolumeConfiguration{
 * Count: 2,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Hana/data: workloads.DiskVolumeConfiguration{
 * Count: 4,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * Hana/log: workloads.DiskVolumeConfiguration{
 * Count: 3,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * Hana/shared: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Os: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 64,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Usr/sap: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * },
 * },
 * InstanceCount: 2,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_M32ts",
 * },
 * },
 * DeploymentType: "ThreeTier",
 * HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * HighAvailabilityType: "AvailabilitySet",
 * },
 * },
 * OsSapConfiguration: workloads.OsSapConfiguration{
 * SapFqdn: "xyz.test.com",
 * },
 * },
 * Environment: pulumi.String("Prod"),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * SapProduct: pulumi.String("S4HANA"),
 * SapVirtualInstanceName: pulumi.String("X00"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("diskConfiguration", Map.of("diskVolumeConfigurations", Map.ofEntries(
 *                             Map.entry("backup", Map.ofEntries(
 *                                 Map.entry("count", 2),
 *                                 Map.entry("sizeGB", 256),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("hana/data", Map.ofEntries(
 *                                 Map.entry("count", 4),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             )),
 *                             Map.entry("hana/log", Map.ofEntries(
 *                                 Map.entry("count", 3),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             )),
 *                             Map.entry("hana/shared", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 256),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("os", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 64),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("usr/sap", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             ))
 *                         ))),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilitySet"))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with Disk and OS configuration for HA System with Availability Zone (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     DiskConfiguration = new AzureNative.Workloads.Inputs.DiskConfigurationArgs
 *                     {
 *                         DiskVolumeConfigurations =
 *                         {
 *                             { "backup", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 2,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "hana/data", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 4,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                             { "hana/log", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 3,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                             { "hana/shared", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 256,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "os", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 64,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "StandardSSD_LRS",
 *                                 },
 *                             } },
 *                             { "usr/sap", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                             {
 *                                 Count = 1,
 *                                 SizeGB = 128,
 *                                 Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                                 {
 *                                     Name = "Premium_LRS",
 *                                 },
 *                             } },
 *                         },
 *                     },
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilityZone",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * Configuration: workloads.DeploymentWithOSConfiguration{
 * AppLocation: "eastus",
 * ConfigurationType: "DeploymentWithOSConfig",
 * InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * AppResourceGroup: "X00-RG",
 * ApplicationServer: workloads.ApplicationServerConfiguration{
 * InstanceCount: 6,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E32ds_v4",
 * },
 * },
 * CentralServer: workloads.CentralServerConfiguration{
 * InstanceCount: 2,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E16ds_v4",
 * },
 * },
 * DatabaseServer: workloads.DatabaseConfiguration{
 * DatabaseType: "HANA",
 * DiskConfiguration: workloads.DiskConfiguration{
 * DiskVolumeConfigurations: interface{}{
 * Backup: workloads.DiskVolumeConfiguration{
 * Count: 2,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Hana/data: workloads.DiskVolumeConfiguration{
 * Count: 4,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * Hana/log: workloads.DiskVolumeConfiguration{
 * Count: 3,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * Hana/shared: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Os: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 64,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Usr/sap: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * },
 * },
 * InstanceCount: 2,
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_M32ts",
 * },
 * },
 * DeploymentType: "ThreeTier",
 * HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * HighAvailabilityType: "AvailabilityZone",
 * },
 * },
 * OsSapConfiguration: workloads.OsSapConfiguration{
 * SapFqdn: "xyz.test.com",
 * },
 * },
 * Environment: pulumi.String("Prod"),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * SapProduct: pulumi.String("S4HANA"),
 * SapVirtualInstanceName: pulumi.String("X00"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("diskConfiguration", Map.of("diskVolumeConfigurations", Map.ofEntries(
 *                             Map.entry("backup", Map.ofEntries(
 *                                 Map.entry("count", 2),
 *                                 Map.entry("sizeGB", 256),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("hana/data", Map.ofEntries(
 *                                 Map.entry("count", 4),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             )),
 *                             Map.entry("hana/log", Map.ofEntries(
 *                                 Map.entry("count", 3),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             )),
 *                             Map.entry("hana/shared", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 256),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("os", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 64),
 *                                 Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                             )),
 *                             Map.entry("usr/sap", Map.ofEntries(
 *                                 Map.entry("count", 1),
 *                                 Map.entry("sizeGB", 128),
 *                                 Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                             ))
 *                         ))),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilityZone"))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with Disk and OS configurations for Single Server System (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = "HANA",
 *                 DbDiskConfiguration = new AzureNative.Workloads.Inputs.DiskConfigurationArgs
 *                 {
 *                     DiskVolumeConfigurations =
 *                     {
 *                         { "backup", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 2,
 *                             SizeGB = 256,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = "StandardSSD_LRS",
 *                             },
 *                         } },
 *                         { "hana/data", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 4,
 *                             SizeGB = 128,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = "Premium_LRS",
 *                             },
 *                         } },
 *                         { "hana/log", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 3,
 *                             SizeGB = 128,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = "Premium_LRS",
 *                             },
 *                         } },
 *                         { "hana/shared", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 1,
 *                             SizeGB = 256,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = "StandardSSD_LRS",
 *                             },
 *                         } },
 *                         { "os", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 1,
 *                             SizeGB = 64,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = "StandardSSD_LRS",
 *                             },
 *                         } },
 *                         { "usr/sap", new AzureNative.Workloads.Inputs.DiskVolumeConfigurationArgs
 *                         {
 *                             Count = 1,
 *                             SizeGB = 128,
 *                             Sku = new AzureNative.Workloads.Inputs.DiskSkuArgs
 *                             {
 *                                 Name = "Premium_LRS",
 *                             },
 *                         } },
 *                     },
 *                 },
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "xyz",
 *                                 PublicKey = "abc",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "NonProd",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * Configuration: workloads.DeploymentWithOSConfiguration{
 * AppLocation: "eastus",
 * ConfigurationType: "DeploymentWithOSConfig",
 * InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * AppResourceGroup: "X00-RG",
 * DatabaseType: "HANA",
 * DbDiskConfiguration: workloads.DiskConfiguration{
 * DiskVolumeConfigurations: interface{}{
 * Backup: workloads.DiskVolumeConfiguration{
 * Count: 2,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Hana/data: workloads.DiskVolumeConfiguration{
 * Count: 4,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * Hana/log: workloads.DiskVolumeConfiguration{
 * Count: 3,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * Hana/shared: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 256,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Os: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 64,
 * Sku: workloads.DiskSku{
 * Name: "StandardSSD_LRS",
 * },
 * },
 * Usr/sap: workloads.DiskVolumeConfiguration{
 * Count: 1,
 * SizeGB: 128,
 * Sku: workloads.DiskSku{
 * Name: "Premium_LRS",
 * },
 * },
 * },
 * },
 * DeploymentType: "SingleServer",
 * NetworkConfiguration: workloads.NetworkConfiguration{
 * IsSecondaryIpEnabled: true,
 * },
 * SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * ImageReference: workloads.ImageReference{
 * Offer: "RHEL-SAP",
 * Publisher: "RedHat",
 * Sku: "84sapha-gen2",
 * Version: "latest",
 * },
 * OsProfile: workloads.OSProfile{
 * AdminUsername: "{your-username}",
 * OsConfiguration: workloads.LinuxConfiguration{
 * DisablePasswordAuthentication: true,
 * OsType: "Linux",
 * SshKeyPair: workloads.SshKeyPair{
 * PrivateKey: "xyz",
 * PublicKey: "abc",
 * },
 * },
 * },
 * VmSize: "Standard_E32ds_v4",
 * },
 * },
 * OsSapConfiguration: workloads.OsSapConfiguration{
 * SapFqdn: "xyz.test.com",
 * },
 * },
 * Environment: pulumi.String("NonProd"),
 * Location: pulumi.String("westcentralus"),
 * ResourceGroupName: pulumi.String("test-rg"),
 * SapProduct: pulumi.String("S4HANA"),
 * SapVirtualInstanceName: pulumi.String("X00"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("databaseType", "HANA"),
 *                     Map.entry("dbDiskConfiguration", Map.of("diskVolumeConfigurations", Map.ofEntries(
 *                         Map.entry("backup", Map.ofEntries(
 *                             Map.entry("count", 2),
 *                             Map.entry("sizeGB", 256),
 *                             Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                         )),
 *                         Map.entry("hana/data", Map.ofEntries(
 *                             Map.entry("count", 4),
 *                             Map.entry("sizeGB", 128),
 *                             Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                         )),
 *                         Map.entry("hana/log", Map.ofEntries(
 *                             Map.entry("count", 3),
 *                             Map.entry("sizeGB", 128),
 *                             Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                         )),
 *                         Map.entry("hana/shared", Map.ofEntries(
 *                             Map.entry("count", 1),
 *                             Map.entry("sizeGB", 256),
 *                             Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                         )),
 *                         Map.entry("os", Map.ofEntries(
 *                             Map.entry("count", 1),
 *                             Map.entry("sizeGB", 64),
 *                             Map.entry("sku", Map.of("name", "StandardSSD_LRS"))
 *                         )),
 *                         Map.entry("usr/sap", Map.ofEntries(
 *                             Map.entry("count", 1),
 *                             Map.entry("sizeGB", 128),
 *                             Map.entry("sku", Map.of("name", "Premium_LRS"))
 *                         ))
 *                     ))),
 *                     Map.entry("deploymentType", "SingleServer"),
 *                     Map.entry("networkConfiguration", Map.of("isSecondaryIpEnabled", true)),
 *                     Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/dindurkhya-e2etesting/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                     Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                         Map.entry("imageReference", Map.ofEntries(
 *                             Map.entry("offer", "RHEL-SAP"),
 *                             Map.entry("publisher", "RedHat"),
 *                             Map.entry("sku", "84sapha-gen2"),
 *                             Map.entry("version", "latest")
 *                         )),
 *                         Map.entry("osProfile", Map.ofEntries(
 *                             Map.entry("adminUsername", "{your-username}"),
 *                             Map.entry("osConfiguration", Map.ofEntries(
 *                                 Map.entry("disablePasswordAuthentication", true),
 *                                 Map.entry("osType", "Linux"),
 *                                 Map.entry("sshKeyPair", Map.ofEntries(
 *                                     Map.entry("privateKey", "xyz"),
 *                                     Map.entry("publicKey", "abc")
 *                                 ))
 *                             ))
 *                         )),
 *                         Map.entry("vmSize", "Standard_E32ds_v4")
 *                     ))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with OS configuration for Distributed System (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier")
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with OS configuration for HA System with Availability Set (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilitySet",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: "AvailabilitySet",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilitySet"))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with OS configuration for HA System with Availability Zone (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilityZone",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: "AvailabilityZone",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilityZone"))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with OS configuration for Single Server System (Recommended)
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = "HANA",
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "xyz",
 *                                 PublicKey = "abc",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "NonProd",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					DatabaseType:     "HANA",
 * 					DeploymentType:   "SingleServer",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 					SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "RHEL-SAP",
 * 							Publisher: "RedHat",
 * 							Sku:       "84sapha-gen2",
 * 							Version:   "latest",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "{your-username}",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								SshKeyPair: workloads.SshKeyPair{
 * 									PrivateKey: "xyz",
 * 									PublicKey:  "abc",
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("NonProd"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("databaseType", "HANA"),
 *                     Map.entry("deploymentType", "SingleServer"),
 *                     Map.entry("networkConfiguration", Map.of("isSecondaryIpEnabled", true)),
 *                     Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                     Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                         Map.entry("imageReference", Map.ofEntries(
 *                             Map.entry("offer", "RHEL-SAP"),
 *                             Map.entry("publisher", "RedHat"),
 *                             Map.entry("sku", "84sapha-gen2"),
 *                             Map.entry("version", "latest")
 *                         )),
 *                         Map.entry("osProfile", Map.ofEntries(
 *                             Map.entry("adminUsername", "{your-username}"),
 *                             Map.entry("osConfiguration", Map.ofEntries(
 *                                 Map.entry("disablePasswordAuthentication", true),
 *                                 Map.entry("osType", "Linux"),
 *                                 Map.entry("sshKeyPair", Map.ofEntries(
 *                                     Map.entry("privateKey", "xyz"),
 *                                     Map.entry("publicKey", "abc")
 *                                 ))
 *                             ))
 *                         )),
 *                         Map.entry("vmSize", "Standard_E32ds_v4")
 *                     ))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with a new SAP Transport Directory Fileshare
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 StorageConfiguration = new AzureNative.Workloads.Inputs.StorageConfigurationArgs
 *                 {
 *                     TransportFileShareConfiguration = new AzureNative.Workloads.Inputs.CreateAndMountFileShareConfigurationArgs
 *                     {
 *                         ConfigurationType = "CreateAndMount",
 *                         ResourceGroup = "rgName",
 *                         StorageAccountName = "storageName",
 *                     },
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					StorageConfiguration: workloads.StorageConfiguration{
 * 						TransportFileShareConfiguration: workloads.CreateAndMountFileShareConfiguration{
 * 							ConfigurationType:  "CreateAndMount",
 * 							ResourceGroup:      "rgName",
 * 							StorageAccountName: "storageName",
 * 						},
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("storageConfiguration", Map.of("transportFileShareConfiguration", Map.ofEntries(
 *                         Map.entry("configurationType", "CreateAndMount"),
 *                         Map.entry("resourceGroup", "rgName"),
 *                         Map.entry("storageAccountName", "storageName")
 *                     )))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure with an existing SAP Transport Directory Fileshare
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 StorageConfiguration = new AzureNative.Workloads.Inputs.StorageConfigurationArgs
 *                 {
 *                     TransportFileShareConfiguration = new AzureNative.Workloads.Inputs.MountFileShareConfigurationArgs
 *                     {
 *                         ConfigurationType = "Mount",
 *                         Id = "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint",
 *                         PrivateEndpointId = "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint",
 *                     },
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					StorageConfiguration: workloads.StorageConfiguration{
 * 						TransportFileShareConfiguration: workloads.MountFileShareConfiguration{
 * 							ConfigurationType: "Mount",
 * 							Id:                "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint",
 * 							PrivateEndpointId: "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint",
 * 						},
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("storageConfiguration", Map.of("transportFileShareConfiguration", Map.ofEntries(
 *                         Map.entry("configurationType", "Mount"),
 *                         Map.entry("id", "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint"),
 *                         Map.entry("privateEndpointId", "/subscriptions/49d64d54-e888-4c46-a868-1936802b762c/resourceGroups/testrg/providers/Microsoft.Network/privateEndpoints/endpoint")
 *                     )))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create Infrastructure without a SAP Transport Directory Fileshare
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 StorageConfiguration = new AzureNative.Workloads.Inputs.StorageConfigurationArgs
 *                 {
 *                     TransportFileShareConfiguration = new AzureNative.Workloads.Inputs.SkipFileShareConfigurationArgs
 *                     {
 *                         ConfigurationType = "Skip",
 *                     },
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					StorageConfiguration: workloads.StorageConfiguration{
 * 						TransportFileShareConfiguration: workloads.SkipFileShareConfiguration{
 * 							ConfigurationType: "Skip",
 * 						},
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("storageConfiguration", Map.of("transportFileShareConfiguration", Map.of("configurationType", "Skip")))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com"))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Detect SAP Software Installation on a Distributed System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "{{resourcegrp}}",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E4ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E4ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "sap.bpaas.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.ExternalInstallationSoftwareConfigurationArgs
 *             {
 *                 CentralServerVmId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *                 SoftwareInstallationType = "External",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "eastus2",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags =
 *         {
 *             { "created by", "azureuser" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "{{resourcegrp}}",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E4ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E4ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "sap.bpaas.com",
 * 				},
 * 				SoftwareConfiguration: workloads.ExternalInstallationSoftwareConfiguration{
 * 					CentralServerVmId:        "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 					SoftwareInstallationType: "External",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("eastus2"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags: pulumi.StringMap{
 * 				"created by": pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "{{resourcegrp}}"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "azureuser"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "{{privateKey}}"),
 *                                         Map.entry("publicKey", "{{sshkey}}")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E4ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "azureuser"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "{{privateKey}}"),
 *                                         Map.entry("publicKey", "{{sshkey}}")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E4ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "azureuser"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "{{privateKey}}"),
 *                                         Map.entry("publicKey", "{{sshkey}}")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("networkConfiguration", Map.of("isSecondaryIpEnabled", true))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "sap.bpaas.com")),
 *                 Map.entry("softwareConfiguration", Map.ofEntries(
 *                     Map.entry("centralServerVmId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0"),
 *                     Map.entry("softwareInstallationType", "External")
 *                 ))
 *             ))
 *             .environment("Prod")
 *             .location("eastus2")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags(Map.of("created by", "azureuser"))
 *             .build());
 *     }
 * }
 * ```
 * ### Detect SAP Software Installation on a Single Server System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 DatabaseType = "HANA",
 *                 DeploymentType = "SingleServer",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *                 SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "RHEL-SAP-HA",
 *                         Publisher = "RedHat",
 *                         Sku = "84sapha-gen2",
 *                         Version = "latest",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "{your-username}",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "xyz",
 *                                 PublicKey = "abc",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.ExternalInstallationSoftwareConfigurationArgs
 *             {
 *                 CentralServerVmId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *                 SoftwareInstallationType = "External",
 *             },
 *         },
 *         Environment = "NonProd",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					DatabaseType:     "HANA",
 * 					DeploymentType:   "SingleServer",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 					SubnetId: "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "RHEL-SAP-HA",
 * 							Publisher: "RedHat",
 * 							Sku:       "84sapha-gen2",
 * 							Version:   "latest",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "{your-username}",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								SshKeyPair: workloads.SshKeyPair{
 * 									PrivateKey: "xyz",
 * 									PublicKey:  "abc",
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 				SoftwareConfiguration: workloads.ExternalInstallationSoftwareConfiguration{
 * 					CentralServerVmId:        "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 					SoftwareInstallationType: "External",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("NonProd"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("databaseType", "HANA"),
 *                     Map.entry("deploymentType", "SingleServer"),
 *                     Map.entry("networkConfiguration", Map.of("isSecondaryIpEnabled", true)),
 *                     Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                     Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                         Map.entry("imageReference", Map.ofEntries(
 *                             Map.entry("offer", "RHEL-SAP-HA"),
 *                             Map.entry("publisher", "RedHat"),
 *                             Map.entry("sku", "84sapha-gen2"),
 *                             Map.entry("version", "latest")
 *                         )),
 *                         Map.entry("osProfile", Map.ofEntries(
 *                             Map.entry("adminUsername", "{your-username}"),
 *                             Map.entry("osConfiguration", Map.ofEntries(
 *                                 Map.entry("disablePasswordAuthentication", true),
 *                                 Map.entry("osType", "Linux"),
 *                                 Map.entry("sshKeyPair", Map.ofEntries(
 *                                     Map.entry("privateKey", "xyz"),
 *                                     Map.entry("publicKey", "abc")
 *                                 ))
 *                             ))
 *                         )),
 *                         Map.entry("vmSize", "Standard_E32ds_v4")
 *                     ))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com")),
 *                 Map.entry("softwareConfiguration", Map.ofEntries(
 *                     Map.entry("centralServerVmId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0"),
 *                     Map.entry("softwareInstallationType", "External")
 *                 ))
 *             ))
 *             .environment("NonProd")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Detect SAP Software Installation on an HA System with Availability Set
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilitySet",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.ExternalInstallationSoftwareConfigurationArgs
 *             {
 *                 CentralServerVmId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *                 SoftwareInstallationType = "External",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: "AvailabilitySet",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 				SoftwareConfiguration: workloads.ExternalInstallationSoftwareConfiguration{
 * 					CentralServerVmId:        "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 					SoftwareInstallationType: "External",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilitySet"))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com")),
 *                 Map.entry("softwareConfiguration", Map.ofEntries(
 *                     Map.entry("centralServerVmId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0"),
 *                     Map.entry("softwareInstallationType", "External")
 *                 ))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Detect SAP Software Installation on an HA System with Availability Zone
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "X00-RG",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 6,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E32ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E16ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     DatabaseType = "HANA",
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "84sapha-gen2",
 *                             Version = "latest",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "{your-username}",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "xyz",
 *                                     PublicKey = "abc",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 HighAvailabilityConfig = new AzureNative.Workloads.Inputs.HighAvailabilityConfigurationArgs
 *                 {
 *                     HighAvailabilityType = "AvailabilityZone",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "xyz.test.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.ExternalInstallationSoftwareConfigurationArgs
 *             {
 *                 CentralServerVmId = "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *                 SoftwareInstallationType = "External",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "westcentralus",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "X00-RG",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 6,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E32ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E16ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						DatabaseType:  "HANA",
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "84sapha-gen2",
 * 								Version:   "latest",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "{your-username}",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "xyz",
 * 										PublicKey:  "abc",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					HighAvailabilityConfig: workloads.HighAvailabilityConfiguration{
 * 						HighAvailabilityType: "AvailabilityZone",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "xyz.test.com",
 * 				},
 * 				SoftwareConfiguration: workloads.ExternalInstallationSoftwareConfiguration{
 * 					CentralServerVmId:        "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 					SoftwareInstallationType: "External",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("westcentralus"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "X00-RG"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 6),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E32ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/appsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E16ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("databaseType", "HANA"),
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Networks/virtualNetworks/test-vnet/subnets/dbsubnet"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "84sapha-gen2"),
 *                                 Map.entry("version", "latest")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "{your-username}"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "xyz"),
 *                                         Map.entry("publicKey", "abc")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("highAvailabilityConfig", Map.of("highAvailabilityType", "AvailabilityZone"))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "xyz.test.com")),
 *                 Map.entry("softwareConfiguration", Map.ofEntries(
 *                     Map.entry("centralServerVmId", "/subscriptions/49d64d54-e966-4c46-a868-1999802b762c/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0"),
 *                     Map.entry("softwareInstallationType", "External")
 *                 ))
 *             ))
 *             .environment("Prod")
 *             .location("westcentralus")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Install SAP Software on Distributed System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.ThreeTierConfigurationArgs
 *             {
 *                 AppResourceGroup = "{{resourcegrp}}",
 *                 ApplicationServer = new AzureNative.Workloads.Inputs.ApplicationServerConfigurationArgs
 *                 {
 *                     InstanceCount = 2,
 *                     SubnetId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "8.2",
 *                             Version = "8.2.2021091201",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E4ds_v4",
 *                     },
 *                 },
 *                 CentralServer = new AzureNative.Workloads.Inputs.CentralServerConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "8.2",
 *                             Version = "8.2.2021091201",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_E4ds_v4",
 *                     },
 *                 },
 *                 DatabaseServer = new AzureNative.Workloads.Inputs.DatabaseConfigurationArgs
 *                 {
 *                     InstanceCount = 1,
 *                     SubnetId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 *                     VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                     {
 *                         ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                         {
 *                             Offer = "RHEL-SAP-HA",
 *                             Publisher = "RedHat",
 *                             Sku = "8.2",
 *                             Version = "8.2.2021091201",
 *                         },
 *                         OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                         {
 *                             AdminUsername = "azureuser",
 *                             OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                             {
 *                                 DisablePasswordAuthentication = true,
 *                                 OsType = "Linux",
 *                                 SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                                 {
 *                                     PrivateKey = "{{privateKey}}",
 *                                     PublicKey = "{{sshkey}}",
 *                                 },
 *                             },
 *                         },
 *                         VmSize = "Standard_M32ts",
 *                     },
 *                 },
 *                 DeploymentType = "ThreeTier",
 *                 NetworkConfiguration = new AzureNative.Workloads.Inputs.NetworkConfigurationArgs
 *                 {
 *                     IsSecondaryIpEnabled = true,
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "sap.bpaas.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.SAPInstallWithoutOSConfigSoftwareConfigurationArgs
 *             {
 *                 BomUrl = "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
 *                 SapBitsStorageAccountId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 *                 SoftwareInstallationType = "SAPInstallWithoutOSConfig",
 *                 SoftwareVersion = "SAP S/4HANA 1909 SPS 03",
 *             },
 *         },
 *         Environment = "Prod",
 *         Location = "eastus2",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags =
 *         {
 *             { "created by", "azureuser" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.ThreeTierConfiguration{
 * 					AppResourceGroup: "{{resourcegrp}}",
 * 					ApplicationServer: workloads.ApplicationServerConfiguration{
 * 						InstanceCount: 2,
 * 						SubnetId:      "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "8.2",
 * 								Version:   "8.2.2021091201",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E4ds_v4",
 * 						},
 * 					},
 * 					CentralServer: workloads.CentralServerConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "8.2",
 * 								Version:   "8.2.2021091201",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_E4ds_v4",
 * 						},
 * 					},
 * 					DatabaseServer: workloads.DatabaseConfiguration{
 * 						InstanceCount: 1,
 * 						SubnetId:      "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app",
 * 						VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 							ImageReference: workloads.ImageReference{
 * 								Offer:     "RHEL-SAP-HA",
 * 								Publisher: "RedHat",
 * 								Sku:       "8.2",
 * 								Version:   "8.2.2021091201",
 * 							},
 * 							OsProfile: workloads.OSProfile{
 * 								AdminUsername: "azureuser",
 * 								OsConfiguration: workloads.LinuxConfiguration{
 * 									DisablePasswordAuthentication: true,
 * 									OsType:                        "Linux",
 * 									SshKeyPair: workloads.SshKeyPair{
 * 										PrivateKey: "{{privateKey}}",
 * 										PublicKey:  "{{sshkey}}",
 * 									},
 * 								},
 * 							},
 * 							VmSize: "Standard_M32ts",
 * 						},
 * 					},
 * 					DeploymentType: "ThreeTier",
 * 					NetworkConfiguration: workloads.NetworkConfiguration{
 * 						IsSecondaryIpEnabled: true,
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "sap.bpaas.com",
 * 				},
 * 				SoftwareConfiguration: workloads.SAPInstallWithoutOSConfigSoftwareConfiguration{
 * 					BomUrl:                   "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
 * 					SapBitsStorageAccountId:  "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 * 					SoftwareInstallationType: "SAPInstallWithoutOSConfig",
 * 					SoftwareVersion:          "SAP S/4HANA 1909 SPS 03",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("Prod"),
 * 			Location:               pulumi.String("eastus2"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags: pulumi.StringMap{
 * 				"created by": pulumi.String("azureuser"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "{{resourcegrp}}"),
 *                     Map.entry("applicationServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 2),
 *                         Map.entry("subnetId", "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "8.2"),
 *                                 Map.entry("version", "8.2.2021091201")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "azureuser"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "{{privateKey}}"),
 *                                         Map.entry("publicKey", "{{sshkey}}")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E4ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("centralServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "8.2"),
 *                                 Map.entry("version", "8.2.2021091201")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "azureuser"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "{{privateKey}}"),
 *                                         Map.entry("publicKey", "{{sshkey}}")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_E4ds_v4")
 *                         ))
 *                     )),
 *                     Map.entry("databaseServer", Map.ofEntries(
 *                         Map.entry("instanceCount", 1),
 *                         Map.entry("subnetId", "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/app"),
 *                         Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                             Map.entry("imageReference", Map.ofEntries(
 *                                 Map.entry("offer", "RHEL-SAP-HA"),
 *                                 Map.entry("publisher", "RedHat"),
 *                                 Map.entry("sku", "8.2"),
 *                                 Map.entry("version", "8.2.2021091201")
 *                             )),
 *                             Map.entry("osProfile", Map.ofEntries(
 *                                 Map.entry("adminUsername", "azureuser"),
 *                                 Map.entry("osConfiguration", Map.ofEntries(
 *                                     Map.entry("disablePasswordAuthentication", true),
 *                                     Map.entry("osType", "Linux"),
 *                                     Map.entry("sshKeyPair", Map.ofEntries(
 *                                         Map.entry("privateKey", "{{privateKey}}"),
 *                                         Map.entry("publicKey", "{{sshkey}}")
 *                                     ))
 *                                 ))
 *                             )),
 *                             Map.entry("vmSize", "Standard_M32ts")
 *                         ))
 *                     )),
 *                     Map.entry("deploymentType", "ThreeTier"),
 *                     Map.entry("networkConfiguration", Map.of("isSecondaryIpEnabled", true))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "sap.bpaas.com")),
 *                 Map.entry("softwareConfiguration", Map.ofEntries(
 *                     Map.entry("bomUrl", "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml"),
 *                     Map.entry("sapBitsStorageAccountId", "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount"),
 *                     Map.entry("softwareInstallationType", "SAPInstallWithoutOSConfig"),
 *                     Map.entry("softwareVersion", "SAP S/4HANA 1909 SPS 03")
 *                 ))
 *             ))
 *             .environment("Prod")
 *             .location("eastus2")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags(Map.of("created by", "azureuser"))
 *             .build());
 *     }
 * }
 * ```
 * ### Install SAP Software on Single Server System
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DeploymentWithOSConfigurationArgs
 *         {
 *             AppLocation = "eastus",
 *             ConfigurationType = "DeploymentWithOSConfig",
 *             InfrastructureConfiguration = new AzureNative.Workloads.Inputs.SingleServerConfigurationArgs
 *             {
 *                 AppResourceGroup = "test-rg",
 *                 DeploymentType = "SingleServer",
 *                 SubnetId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/testsubnet",
 *                 VirtualMachineConfiguration = new AzureNative.Workloads.Inputs.VirtualMachineConfigurationArgs
 *                 {
 *                     ImageReference = new AzureNative.Workloads.Inputs.ImageReferenceArgs
 *                     {
 *                         Offer = "SLES-SAP",
 *                         Publisher = "SUSE",
 *                         Sku = "12-sp4-gen2",
 *                         Version = "2022.02.01",
 *                     },
 *                     OsProfile = new AzureNative.Workloads.Inputs.OSProfileArgs
 *                     {
 *                         AdminUsername = "azureappadmin",
 *                         OsConfiguration = new AzureNative.Workloads.Inputs.LinuxConfigurationArgs
 *                         {
 *                             DisablePasswordAuthentication = true,
 *                             OsType = "Linux",
 *                             SshKeyPair = new AzureNative.Workloads.Inputs.SshKeyPairArgs
 *                             {
 *                                 PrivateKey = "{{privateKey}}",
 *                                 PublicKey = "{{sshkey}}",
 *                             },
 *                         },
 *                     },
 *                     VmSize = "Standard_E32ds_v4",
 *                 },
 *             },
 *             OsSapConfiguration = new AzureNative.Workloads.Inputs.OsSapConfigurationArgs
 *             {
 *                 SapFqdn = "sap.bpaas.com",
 *             },
 *             SoftwareConfiguration = new AzureNative.Workloads.Inputs.SAPInstallWithoutOSConfigSoftwareConfigurationArgs
 *             {
 *                 BomUrl = "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
 *                 SapBitsStorageAccountId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 *                 SoftwareInstallationType = "SAPInstallWithoutOSConfig",
 *                 SoftwareVersion = "SAP S/4HANA 1909 SPS 03",
 *             },
 *         },
 *         Environment = "NonProd",
 *         Location = "eastus2",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DeploymentWithOSConfiguration{
 * 				AppLocation:       "eastus",
 * 				ConfigurationType: "DeploymentWithOSConfig",
 * 				InfrastructureConfiguration: workloads.SingleServerConfiguration{
 * 					AppResourceGroup: "test-rg",
 * 					DeploymentType:   "SingleServer",
 * 					SubnetId:         "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/testsubnet",
 * 					VirtualMachineConfiguration: workloads.VirtualMachineConfiguration{
 * 						ImageReference: workloads.ImageReference{
 * 							Offer:     "SLES-SAP",
 * 							Publisher: "SUSE",
 * 							Sku:       "12-sp4-gen2",
 * 							Version:   "2022.02.01",
 * 						},
 * 						OsProfile: workloads.OSProfile{
 * 							AdminUsername: "azureappadmin",
 * 							OsConfiguration: workloads.LinuxConfiguration{
 * 								DisablePasswordAuthentication: true,
 * 								OsType:                        "Linux",
 * 								SshKeyPair: workloads.SshKeyPair{
 * 									PrivateKey: "{{privateKey}}",
 * 									PublicKey:  "{{sshkey}}",
 * 								},
 * 							},
 * 						},
 * 						VmSize: "Standard_E32ds_v4",
 * 					},
 * 				},
 * 				OsSapConfiguration: workloads.OsSapConfiguration{
 * 					SapFqdn: "sap.bpaas.com",
 * 				},
 * 				SoftwareConfiguration: workloads.SAPInstallWithoutOSConfigSoftwareConfiguration{
 * 					BomUrl:                   "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml",
 * 					SapBitsStorageAccountId:  "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount",
 * 					SoftwareInstallationType: "SAPInstallWithoutOSConfig",
 * 					SoftwareVersion:          "SAP S/4HANA 1909 SPS 03",
 * 				},
 * 			},
 * 			Environment:            pulumi.String("NonProd"),
 * 			Location:               pulumi.String("eastus2"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags:                   nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("appLocation", "eastus"),
 *                 Map.entry("configurationType", "DeploymentWithOSConfig"),
 *                 Map.entry("infrastructureConfiguration", Map.ofEntries(
 *                     Map.entry("appResourceGroup", "test-rg"),
 *                     Map.entry("deploymentType", "SingleServer"),
 *                     Map.entry("subnetId", "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/testsubnet"),
 *                     Map.entry("virtualMachineConfiguration", Map.ofEntries(
 *                         Map.entry("imageReference", Map.ofEntries(
 *                             Map.entry("offer", "SLES-SAP"),
 *                             Map.entry("publisher", "SUSE"),
 *                             Map.entry("sku", "12-sp4-gen2"),
 *                             Map.entry("version", "2022.02.01")
 *                         )),
 *                         Map.entry("osProfile", Map.ofEntries(
 *                             Map.entry("adminUsername", "azureappadmin"),
 *                             Map.entry("osConfiguration", Map.ofEntries(
 *                                 Map.entry("disablePasswordAuthentication", true),
 *                                 Map.entry("osType", "Linux"),
 *                                 Map.entry("sshKeyPair", Map.ofEntries(
 *                                     Map.entry("privateKey", "{{privateKey}}"),
 *                                     Map.entry("publicKey", "{{sshkey}}")
 *                                 ))
 *                             ))
 *                         )),
 *                         Map.entry("vmSize", "Standard_E32ds_v4")
 *                     ))
 *                 )),
 *                 Map.entry("osSapConfiguration", Map.of("sapFqdn", "sap.bpaas.com")),
 *                 Map.entry("softwareConfiguration", Map.ofEntries(
 *                     Map.entry("bomUrl", "https://teststorageaccount.blob.core.windows.net/sapbits/sapfiles/boms/S41909SPS03_v0011ms/S41909SPS03_v0011ms.yaml"),
 *                     Map.entry("sapBitsStorageAccountId", "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/teststorageaccount"),
 *                     Map.entry("softwareInstallationType", "SAPInstallWithoutOSConfig"),
 *                     Map.entry("softwareVersion", "SAP S/4HANA 1909 SPS 03")
 *                 ))
 *             ))
 *             .environment("NonProd")
 *             .location("eastus2")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Register existing SAP system as Virtual Instance for SAP solutions with optional customizations.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DiscoveryConfigurationArgs
 *         {
 *             CentralServerVmId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *             ConfigurationType = "Discovery",
 *             ManagedRgStorageAccountName = "q20saacssgrs",
 *         },
 *         Environment = "NonProd",
 *         Location = "northeurope",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags =
 *         {
 *             { "createdby", "abc@microsoft.com" },
 *             { "test", "abc" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DiscoveryConfiguration{
 * 				CentralServerVmId:           "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 				ConfigurationType:           "Discovery",
 * 				ManagedRgStorageAccountName: "q20saacssgrs",
 * 			},
 * 			Environment:            pulumi.String("NonProd"),
 * 			Location:               pulumi.String("northeurope"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags: pulumi.StringMap{
 * 				"createdby": pulumi.String("abc@microsoft.com"),
 * 				"test":      pulumi.String("abc"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("centralServerVmId", "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0"),
 *                 Map.entry("configurationType", "Discovery"),
 *                 Map.entry("managedRgStorageAccountName", "q20saacssgrs")
 *             ))
 *             .environment("NonProd")
 *             .location("northeurope")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags(Map.ofEntries(
 *                 Map.entry("createdby", "abc@microsoft.com"),
 *                 Map.entry("test", "abc")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Register existing SAP system as Virtual Instance for SAP solutions.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sapVirtualInstance = new AzureNative.Workloads.SAPVirtualInstance("sapVirtualInstance", new()
 *     {
 *         Configuration = new AzureNative.Workloads.Inputs.DiscoveryConfigurationArgs
 *         {
 *             CentralServerVmId = "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 *             ConfigurationType = "Discovery",
 *         },
 *         Environment = "NonProd",
 *         Location = "northeurope",
 *         ResourceGroupName = "test-rg",
 *         SapProduct = "S4HANA",
 *         SapVirtualInstanceName = "X00",
 *         Tags =
 *         {
 *             { "createdby", "abc@microsoft.com" },
 *             { "test", "abc" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/workloads/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workloads.NewSAPVirtualInstance(ctx, "sapVirtualInstance", &workloads.SAPVirtualInstanceArgs{
 * 			Configuration: workloads.DiscoveryConfiguration{
 * 				CentralServerVmId: "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0",
 * 				ConfigurationType: "Discovery",
 * 			},
 * 			Environment:            pulumi.String("NonProd"),
 * 			Location:               pulumi.String("northeurope"),
 * 			ResourceGroupName:      pulumi.String("test-rg"),
 * 			SapProduct:             pulumi.String("S4HANA"),
 * 			SapVirtualInstanceName: pulumi.String("X00"),
 * 			Tags: pulumi.StringMap{
 * 				"createdby": pulumi.String("abc@microsoft.com"),
 * 				"test":      pulumi.String("abc"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstance;
 * import com.pulumi.azurenative.workloads.SAPVirtualInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sapVirtualInstance = new SAPVirtualInstance("sapVirtualInstance", SAPVirtualInstanceArgs.builder()
 *             .configuration(Map.ofEntries(
 *                 Map.entry("centralServerVmId", "/subscriptions/8e17e36c-42e9-4cd5-a078-7b44883414e0/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/sapq20scsvm0"),
 *                 Map.entry("configurationType", "Discovery")
 *             ))
 *             .environment("NonProd")
 *             .location("northeurope")
 *             .resourceGroupName("test-rg")
 *             .sapProduct("S4HANA")
 *             .sapVirtualInstanceName("X00")
 *             .tags(Map.ofEntries(
 *                 Map.entry("createdby", "abc@microsoft.com"),
 *                 Map.entry("test", "abc")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:workloads:SAPVirtualInstance Q20 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapVirtualInstances/{sapVirtualInstanceName}
 * ```
 */
public class SAPVirtualInstance internal constructor(
    override val javaResource: com.pulumi.azurenative.workloads.SAPVirtualInstance,
) : KotlinCustomResource(javaResource, SAPVirtualInstanceMapper) {
    /**
     * Defines if the SAP system is being created using Azure Center for SAP solutions (ACSS) or if an existing SAP system is being registered with ACSS
     */
    public val configuration: Output<Any>
        get() = javaResource.configuration().applyValue({ args0 -> args0 })

    /**
     * Defines the environment type - Production/Non Production.
     */
    public val environment: Output<String>
        get() = javaResource.environment().applyValue({ args0 -> args0 })

    /**
     * Indicates any errors on the Virtual Instance for SAP solutions resource.
     */
    public val errors: Output<SAPVirtualInstanceErrorResponse>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.let({ args0 ->
                sAPVirtualInstanceErrorResponseToKotlin(args0)
            })
        })

    /**
     * Defines the health of SAP Instances.
     */
    public val health: Output<String>
        get() = javaResource.health().applyValue({ args0 -> args0 })

    /**
     * A pre-created user assigned identity with appropriate roles assigned. To learn more on identity and roles required, visit the ACSS how-to-guide.
     */
    public val identity: Output<UserAssignedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    userAssignedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Managed resource group configuration
     */
    public val managedResourceGroupConfiguration: Output<ManagedRGConfigurationResponse>?
        get() = javaResource.managedResourceGroupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedRGConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the provisioning states.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Defines the SAP Product type.
     */
    public val sapProduct: Output<String>
        get() = javaResource.sapProduct().applyValue({ args0 -> args0 })

    /**
     * Defines the Virtual Instance for SAP state.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Defines the SAP Instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SAPVirtualInstanceMapper : ResourceMapper<SAPVirtualInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.workloads.SAPVirtualInstance::class == javaResource::class

    override fun map(javaResource: Resource): SAPVirtualInstance = SAPVirtualInstance(
        javaResource as
            com.pulumi.azurenative.workloads.SAPVirtualInstance,
    )
}

/**
 * @see [SAPVirtualInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SAPVirtualInstance].
 */
public suspend fun sapVirtualInstance(
    name: String,
    block: suspend SAPVirtualInstanceResourceBuilder.() -> Unit,
): SAPVirtualInstance {
    val builder = SAPVirtualInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SAPVirtualInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sapVirtualInstance(name: String): SAPVirtualInstance {
    val builder = SAPVirtualInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
