@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specify the crypto provider being used (commoncrypto/openssl). If this argument is not provided, it is automatically determined by searching in the configuration files.
 */
public enum class SslCryptoProvider(
    public val javaValue: com.pulumi.azurenative.workloads.enums.SslCryptoProvider,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.enums.SslCryptoProvider> {
    Commoncrypto(com.pulumi.azurenative.workloads.enums.SslCryptoProvider.Commoncrypto),
    Openssl(com.pulumi.azurenative.workloads.enums.SslCryptoProvider.Openssl),
    ;

    override fun toJava(): com.pulumi.azurenative.workloads.enums.SslCryptoProvider = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.enums.SslCryptoProvider):
            SslCryptoProvider = SslCryptoProvider.values().first { it.javaValue == javaType }
    }
}
