@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DailyRetentionScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Daily retention schedule.
 * @property retentionDuration Retention duration of retention Policy.
 * @property retentionTimes Retention times of retention policy.
 */
public data class DailyRetentionScheduleArgs(
    public val retentionDuration: Output<RetentionDurationArgs>? = null,
    public val retentionTimes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DailyRetentionScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DailyRetentionScheduleArgs =
        com.pulumi.azurenative.workloads.inputs.DailyRetentionScheduleArgs.builder()
            .retentionDuration(retentionDuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retentionTimes(retentionTimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DailyRetentionScheduleArgs].
 */
@PulumiTagMarker
public class DailyRetentionScheduleArgsBuilder internal constructor() {
    private var retentionDuration: Output<RetentionDurationArgs>? = null

    private var retentionTimes: Output<List<String>>? = null

    /**
     * @param value Retention duration of retention Policy.
     */
    @JvmName("vqtfsetdbolyimhy")
    public suspend fun retentionDuration(`value`: Output<RetentionDurationArgs>) {
        this.retentionDuration = value
    }

    /**
     * @param value Retention times of retention policy.
     */
    @JvmName("fdslfrqiqnwcqdfs")
    public suspend fun retentionTimes(`value`: Output<List<String>>) {
        this.retentionTimes = value
    }

    @JvmName("equiplkexbdxbndw")
    public suspend fun retentionTimes(vararg values: Output<String>) {
        this.retentionTimes = Output.all(values.asList())
    }

    /**
     * @param values Retention times of retention policy.
     */
    @JvmName("ibeevuyikycvraun")
    public suspend fun retentionTimes(values: List<Output<String>>) {
        this.retentionTimes = Output.all(values)
    }

    /**
     * @param value Retention duration of retention Policy.
     */
    @JvmName("hxyygenpskxvxeiw")
    public suspend fun retentionDuration(`value`: RetentionDurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDuration = mapped
    }

    /**
     * @param argument Retention duration of retention Policy.
     */
    @JvmName("lqtvlwnbidnaqhhm")
    public suspend fun retentionDuration(argument: suspend RetentionDurationArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionDurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionDuration = mapped
    }

    /**
     * @param value Retention times of retention policy.
     */
    @JvmName("qjfgsymdueonjrac")
    public suspend fun retentionTimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionTimes = mapped
    }

    /**
     * @param values Retention times of retention policy.
     */
    @JvmName("mrxbnuqgdruvgqmg")
    public suspend fun retentionTimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionTimes = mapped
    }

    internal fun build(): DailyRetentionScheduleArgs = DailyRetentionScheduleArgs(
        retentionDuration = retentionDuration,
        retentionTimes = retentionTimes,
    )
}
