@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.DiskVolumeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The disk configuration required for the selected volume.
 * @property count The total number of disks required for the concerned volume.
 * @property sizeGB The disk size in GB.
 * @property sku The disk SKU details.
 */
public data class DiskVolumeConfigurationArgs(
    public val count: Output<Double>? = null,
    public val sizeGB: Output<Double>? = null,
    public val sku: Output<DiskSkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.DiskVolumeConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.DiskVolumeConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.DiskVolumeConfigurationArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .sizeGB(sizeGB?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DiskVolumeConfigurationArgs].
 */
@PulumiTagMarker
public class DiskVolumeConfigurationArgsBuilder internal constructor() {
    private var count: Output<Double>? = null

    private var sizeGB: Output<Double>? = null

    private var sku: Output<DiskSkuArgs>? = null

    /**
     * @param value The total number of disks required for the concerned volume.
     */
    @JvmName("cekoeuhvyskidqer")
    public suspend fun count(`value`: Output<Double>) {
        this.count = value
    }

    /**
     * @param value The disk size in GB.
     */
    @JvmName("goowdkwhpgckbucl")
    public suspend fun sizeGB(`value`: Output<Double>) {
        this.sizeGB = value
    }

    /**
     * @param value The disk SKU details.
     */
    @JvmName("nhtvsfqhnduufpjb")
    public suspend fun sku(`value`: Output<DiskSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value The total number of disks required for the concerned volume.
     */
    @JvmName("jjmurhqmptlgxdkf")
    public suspend fun count(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The disk size in GB.
     */
    @JvmName("fveoqhqvdfuddmyj")
    public suspend fun sizeGB(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeGB = mapped
    }

    /**
     * @param value The disk SKU details.
     */
    @JvmName("tdddsvgfrgfxwyrt")
    public suspend fun sku(`value`: DiskSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The disk SKU details.
     */
    @JvmName("aebwenurfqxtpqdc")
    public suspend fun sku(argument: suspend DiskSkuArgsBuilder.() -> Unit) {
        val toBeMapped = DiskSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): DiskVolumeConfigurationArgs = DiskVolumeConfigurationArgs(
        count = count,
        sizeGB = sizeGB,
        sku = sku,
    )
}
