@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.ExternalInstallationSoftwareConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SAP Software configuration Input when the software is installed externally outside the service.
 * @property centralServerVmId The resource ID of the virtual machine containing the central server instance.
 * @property softwareInstallationType The SAP software installation Type.
 * Expected value is 'External'.
 */
public data class ExternalInstallationSoftwareConfigurationArgs(
    public val centralServerVmId: Output<String>? = null,
    public val softwareInstallationType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.ExternalInstallationSoftwareConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.ExternalInstallationSoftwareConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.ExternalInstallationSoftwareConfigurationArgs.builder()
            .centralServerVmId(centralServerVmId?.applyValue({ args0 -> args0 }))
            .softwareInstallationType(softwareInstallationType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExternalInstallationSoftwareConfigurationArgs].
 */
@PulumiTagMarker
public class ExternalInstallationSoftwareConfigurationArgsBuilder internal constructor() {
    private var centralServerVmId: Output<String>? = null

    private var softwareInstallationType: Output<String>? = null

    /**
     * @param value The resource ID of the virtual machine containing the central server instance.
     */
    @JvmName("ptlnykvantsgwebw")
    public suspend fun centralServerVmId(`value`: Output<String>) {
        this.centralServerVmId = value
    }

    /**
     * @param value The SAP software installation Type.
     * Expected value is 'External'.
     */
    @JvmName("ehfnjamigtuyqird")
    public suspend fun softwareInstallationType(`value`: Output<String>) {
        this.softwareInstallationType = value
    }

    /**
     * @param value The resource ID of the virtual machine containing the central server instance.
     */
    @JvmName("kpmepixyoekvaeqa")
    public suspend fun centralServerVmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.centralServerVmId = mapped
    }

    /**
     * @param value The SAP software installation Type.
     * Expected value is 'External'.
     */
    @JvmName("iqimippvfdcoskbw")
    public suspend fun softwareInstallationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareInstallationType = mapped
    }

    internal fun build(): ExternalInstallationSoftwareConfigurationArgs =
        ExternalInstallationSoftwareConfigurationArgs(
            centralServerVmId = centralServerVmId,
            softwareInstallationType = softwareInstallationType ?: throw
                PulumiNullFieldException("softwareInstallationType"),
        )
}
