@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSAPSizingRecommendationsPlainArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseScaleMethod
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDeploymentType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPEnvironmentType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPHighAvailabilityType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPProductType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appLocation The geo-location where the resource is to be created.
 * @property databaseType The database type.
 * @property dbMemory The database memory configuration.
 * @property dbScaleMethod The DB scale method.
 * @property deploymentType The deployment type. Eg: SingleServer/ThreeTier
 * @property environment Defines the environment type - Production/Non Production.
 * @property highAvailabilityType The high availability type.
 * @property location The name of Azure region.
 * @property sapProduct Defines the SAP Product type.
 * @property saps The SAP Application Performance Standard measurement.
 */
public data class GetSAPSizingRecommendationsPlainArgs(
    public val appLocation: String,
    public val databaseType: Either<String, SAPDatabaseType>,
    public val dbMemory: Double,
    public val dbScaleMethod: Either<String, SAPDatabaseScaleMethod>? = null,
    public val deploymentType: Either<String, SAPDeploymentType>,
    public val environment: Either<String, SAPEnvironmentType>,
    public val highAvailabilityType: Either<String, SAPHighAvailabilityType>? = null,
    public val location: String,
    public val sapProduct: Either<String, SAPProductType>,
    public val saps: Double,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSAPSizingRecommendationsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.GetSAPSizingRecommendationsPlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSAPSizingRecommendationsPlainArgs.builder()
            .appLocation(appLocation.let({ args0 -> args0 }))
            .databaseType(
                databaseType.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dbMemory(dbMemory.let({ args0 -> args0 }))
            .dbScaleMethod(
                dbScaleMethod?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deploymentType(
                deploymentType.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .environment(
                environment.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .highAvailabilityType(
                highAvailabilityType?.let({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location.let({ args0 -> args0 }))
            .sapProduct(
                sapProduct.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .saps(saps.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSAPSizingRecommendationsPlainArgs].
 */
@PulumiTagMarker
public class GetSAPSizingRecommendationsPlainArgsBuilder internal constructor() {
    private var appLocation: String? = null

    private var databaseType: Either<String, SAPDatabaseType>? = null

    private var dbMemory: Double? = null

    private var dbScaleMethod: Either<String, SAPDatabaseScaleMethod>? = null

    private var deploymentType: Either<String, SAPDeploymentType>? = null

    private var environment: Either<String, SAPEnvironmentType>? = null

    private var highAvailabilityType: Either<String, SAPHighAvailabilityType>? = null

    private var location: String? = null

    private var sapProduct: Either<String, SAPProductType>? = null

    private var saps: Double? = null

    /**
     * @param value The geo-location where the resource is to be created.
     */
    @JvmName("qfkiwdcpjevadwof")
    public suspend fun appLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appLocation = mapped
    }

    /**
     * @param value The database type.
     */
    @JvmName("skquqeqbluekxmkr")
    public suspend fun databaseType(`value`: Either<String, SAPDatabaseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database type.
     */
    @JvmName("doiefttaybllnvuy")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database type.
     */
    @JvmName("nakkrvgsoqjatqcc")
    public fun databaseType(`value`: SAPDatabaseType) {
        val toBeMapped = Either.ofRight<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database memory configuration.
     */
    @JvmName("qbbincmwepmaugtm")
    public suspend fun dbMemory(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbMemory = mapped
    }

    /**
     * @param value The DB scale method.
     */
    @JvmName("dvgbeesysoidojpe")
    public suspend fun dbScaleMethod(`value`: Either<String, SAPDatabaseScaleMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbScaleMethod = mapped
    }

    /**
     * @param value The DB scale method.
     */
    @JvmName("mddcghdpvrfjtpii")
    public fun dbScaleMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDatabaseScaleMethod>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbScaleMethod = mapped
    }

    /**
     * @param value The DB scale method.
     */
    @JvmName("lppqgbgiysvedkdu")
    public fun dbScaleMethod(`value`: SAPDatabaseScaleMethod) {
        val toBeMapped = Either.ofRight<String, SAPDatabaseScaleMethod>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbScaleMethod = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("isjrpntdbwkpuqnb")
    public suspend fun deploymentType(`value`: Either<String, SAPDeploymentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("dwuaxqwitydaarbf")
    public fun deploymentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDeploymentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("hqvannvamkkoiuap")
    public fun deploymentType(`value`: SAPDeploymentType) {
        val toBeMapped = Either.ofRight<String, SAPDeploymentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("xfctnfaeeovyybyu")
    public suspend fun environment(`value`: Either<String, SAPEnvironmentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("uhfjhmcwtixlsydo")
    public fun environment(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPEnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("qkwtjforujyfsnbd")
    public fun environment(`value`: SAPEnvironmentType) {
        val toBeMapped = Either.ofRight<String, SAPEnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("dinnlrriuvftlxev")
    public suspend fun highAvailabilityType(`value`: Either<String, SAPHighAvailabilityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.highAvailabilityType = mapped
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("tqthywjigngpdaag")
    public fun highAvailabilityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPHighAvailabilityType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.highAvailabilityType = mapped
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("bqvqktihlrbdobkp")
    public fun highAvailabilityType(`value`: SAPHighAvailabilityType) {
        val toBeMapped = Either.ofRight<String, SAPHighAvailabilityType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.highAvailabilityType = mapped
    }

    /**
     * @param value The name of Azure region.
     */
    @JvmName("rtiipxxsvqultbrg")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("rabdbjuivervfplx")
    public suspend fun sapProduct(`value`: Either<String, SAPProductType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("uyaxduvmrtscnecr")
    public fun sapProduct(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPProductType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("orgbskwivgdajgdf")
    public fun sapProduct(`value`: SAPProductType) {
        val toBeMapped = Either.ofRight<String, SAPProductType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value The SAP Application Performance Standard measurement.
     */
    @JvmName("gkcexcdkpcoyqpyx")
    public suspend fun saps(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.saps = mapped
    }

    internal fun build(): GetSAPSizingRecommendationsPlainArgs = GetSAPSizingRecommendationsPlainArgs(
        appLocation = appLocation ?: throw PulumiNullFieldException("appLocation"),
        databaseType = databaseType ?: throw PulumiNullFieldException("databaseType"),
        dbMemory = dbMemory ?: throw PulumiNullFieldException("dbMemory"),
        dbScaleMethod = dbScaleMethod,
        deploymentType = deploymentType ?: throw PulumiNullFieldException("deploymentType"),
        environment = environment ?: throw PulumiNullFieldException("environment"),
        highAvailabilityType = highAvailabilityType,
        location = location ?: throw PulumiNullFieldException("location"),
        sapProduct = sapProduct ?: throw PulumiNullFieldException("sapProduct"),
        saps = saps ?: throw PulumiNullFieldException("saps"),
    )
}
