@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.GetSAPSupportedSkuPlainArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDatabaseType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPDeploymentType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPEnvironmentType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPHighAvailabilityType
import com.pulumi.azurenative.workloads.kotlin.enums.SAPProductType
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property appLocation The geo-location where the resource is to be created.
 * @property databaseType The database type. Eg: HANA, DB2, etc
 * @property deploymentType The deployment type. Eg: SingleServer/ThreeTier
 * @property environment Defines the environment type - Production/Non Production.
 * @property highAvailabilityType The high availability type.
 * @property location The name of Azure region.
 * @property sapProduct Defines the SAP Product type.
 */
public data class GetSAPSupportedSkuPlainArgs(
    public val appLocation: String,
    public val databaseType: Either<String, SAPDatabaseType>,
    public val deploymentType: Either<String, SAPDeploymentType>,
    public val environment: Either<String, SAPEnvironmentType>,
    public val highAvailabilityType: Either<String, SAPHighAvailabilityType>? = null,
    public val location: String,
    public val sapProduct: Either<String, SAPProductType>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.GetSAPSupportedSkuPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.GetSAPSupportedSkuPlainArgs =
        com.pulumi.azurenative.workloads.inputs.GetSAPSupportedSkuPlainArgs.builder()
            .appLocation(appLocation.let({ args0 -> args0 }))
            .databaseType(
                databaseType.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deploymentType(
                deploymentType.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .environment(
                environment.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .highAvailabilityType(
                highAvailabilityType?.let({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .location(location.let({ args0 -> args0 }))
            .sapProduct(
                sapProduct.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetSAPSupportedSkuPlainArgs].
 */
@PulumiTagMarker
public class GetSAPSupportedSkuPlainArgsBuilder internal constructor() {
    private var appLocation: String? = null

    private var databaseType: Either<String, SAPDatabaseType>? = null

    private var deploymentType: Either<String, SAPDeploymentType>? = null

    private var environment: Either<String, SAPEnvironmentType>? = null

    private var highAvailabilityType: Either<String, SAPHighAvailabilityType>? = null

    private var location: String? = null

    private var sapProduct: Either<String, SAPProductType>? = null

    /**
     * @param value The geo-location where the resource is to be created.
     */
    @JvmName("trhvsdmevnwxrlfg")
    public suspend fun appLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appLocation = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("ipwxksiswdplsdhh")
    public suspend fun databaseType(`value`: Either<String, SAPDatabaseType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("flbrcxdrljvjwswx")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The database type. Eg: HANA, DB2, etc
     */
    @JvmName("ylafjkvoxwtheuxg")
    public fun databaseType(`value`: SAPDatabaseType) {
        val toBeMapped = Either.ofRight<String, SAPDatabaseType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseType = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("fgdqdttqggwnarrv")
    public suspend fun deploymentType(`value`: Either<String, SAPDeploymentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("eedhikkuqkmvxolq")
    public fun deploymentType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPDeploymentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value The deployment type. Eg: SingleServer/ThreeTier
     */
    @JvmName("hnggpeqxsbbhmvbp")
    public fun deploymentType(`value`: SAPDeploymentType) {
        val toBeMapped = Either.ofRight<String, SAPDeploymentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentType = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("eixwahxhgccnayef")
    public suspend fun environment(`value`: Either<String, SAPEnvironmentType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("ljlawvghhkmdspcu")
    public fun environment(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPEnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value Defines the environment type - Production/Non Production.
     */
    @JvmName("bhtdvssyufpfwddv")
    public fun environment(`value`: SAPEnvironmentType) {
        val toBeMapped = Either.ofRight<String, SAPEnvironmentType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environment = mapped
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("nhbtqngmvdomyafh")
    public suspend fun highAvailabilityType(`value`: Either<String, SAPHighAvailabilityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.highAvailabilityType = mapped
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("qkdoloiirktwqnwv")
    public fun highAvailabilityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPHighAvailabilityType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.highAvailabilityType = mapped
    }

    /**
     * @param value The high availability type.
     */
    @JvmName("ujombrpajvmclqyj")
    public fun highAvailabilityType(`value`: SAPHighAvailabilityType) {
        val toBeMapped = Either.ofRight<String, SAPHighAvailabilityType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.highAvailabilityType = mapped
    }

    /**
     * @param value The name of Azure region.
     */
    @JvmName("quujxbvmjvwehmtm")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("hyqmoisymdrfetof")
    public suspend fun sapProduct(`value`: Either<String, SAPProductType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("htjmouuvdphfkaee")
    public fun sapProduct(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SAPProductType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    /**
     * @param value Defines the SAP Product type.
     */
    @JvmName("hlwtjgrivhknfwsr")
    public fun sapProduct(`value`: SAPProductType) {
        val toBeMapped = Either.ofRight<String, SAPProductType>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sapProduct = mapped
    }

    internal fun build(): GetSAPSupportedSkuPlainArgs = GetSAPSupportedSkuPlainArgs(
        appLocation = appLocation ?: throw PulumiNullFieldException("appLocation"),
        databaseType = databaseType ?: throw PulumiNullFieldException("databaseType"),
        deploymentType = deploymentType ?: throw PulumiNullFieldException("deploymentType"),
        environment = environment ?: throw PulumiNullFieldException("environment"),
        highAvailabilityType = highAvailabilityType,
        location = location ?: throw PulumiNullFieldException("location"),
        sapProduct = sapProduct ?: throw PulumiNullFieldException("sapProduct"),
    )
}
