@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.HanaBackupDataArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the HANA Backup data for a virtual instance for SAP.
 * @property backupPolicy Defines the policy properties for database backup.
 * @property backupType The type of backup, VM, SQL or HANA.
 * Expected value is 'HANA'.
 * @property dbInstanceSnapshotBackupPolicy Defines the policy properties for database backup.
 * @property hdbuserstoreKeyName Name of the HANA Database User Store Key.
 * @property instanceNumber Gets or sets the database instance number.
 * @property recoveryServicesVault The properties of the recovery services vault used for backup.
 * @property sslConfiguration Path of the SSL key store.
 */
public data class HanaBackupDataArgs(
    public val backupPolicy: Output<DBBackupPolicyPropertiesArgs>,
    public val backupType: Output<String>,
    public val dbInstanceSnapshotBackupPolicy: Output<DBBackupPolicyPropertiesArgs>? = null,
    public val hdbuserstoreKeyName: Output<String>,
    public val instanceNumber: Output<String>? = null,
    public val recoveryServicesVault:
    Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>,
    public val sslConfiguration: Output<SSLConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.HanaBackupDataArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.HanaBackupDataArgs =
        com.pulumi.azurenative.workloads.inputs.HanaBackupDataArgs.builder()
            .backupPolicy(backupPolicy.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupType(backupType.applyValue({ args0 -> args0 }))
            .dbInstanceSnapshotBackupPolicy(
                dbInstanceSnapshotBackupPolicy?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .hdbuserstoreKeyName(hdbuserstoreKeyName.applyValue({ args0 -> args0 }))
            .instanceNumber(instanceNumber?.applyValue({ args0 -> args0 }))
            .recoveryServicesVault(
                recoveryServicesVault.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .sslConfiguration(
                sslConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [HanaBackupDataArgs].
 */
@PulumiTagMarker
public class HanaBackupDataArgsBuilder internal constructor() {
    private var backupPolicy: Output<DBBackupPolicyPropertiesArgs>? = null

    private var backupType: Output<String>? = null

    private var dbInstanceSnapshotBackupPolicy: Output<DBBackupPolicyPropertiesArgs>? = null

    private var hdbuserstoreKeyName: Output<String>? = null

    private var instanceNumber: Output<String>? = null

    private var recoveryServicesVault:
        Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>? = null

    private var sslConfiguration: Output<SSLConfigurationArgs>? = null

    /**
     * @param value Defines the policy properties for database backup.
     */
    @JvmName("junfucoqeohoedci")
    public suspend fun backupPolicy(`value`: Output<DBBackupPolicyPropertiesArgs>) {
        this.backupPolicy = value
    }

    /**
     * @param value The type of backup, VM, SQL or HANA.
     * Expected value is 'HANA'.
     */
    @JvmName("tauhayhqxjjqpcsh")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value Defines the policy properties for database backup.
     */
    @JvmName("xgienpnrtudcpcxp")
    public suspend fun dbInstanceSnapshotBackupPolicy(`value`: Output<DBBackupPolicyPropertiesArgs>) {
        this.dbInstanceSnapshotBackupPolicy = value
    }

    /**
     * @param value Name of the HANA Database User Store Key.
     */
    @JvmName("ntblgfkljiqfygqx")
    public suspend fun hdbuserstoreKeyName(`value`: Output<String>) {
        this.hdbuserstoreKeyName = value
    }

    /**
     * @param value Gets or sets the database instance number.
     */
    @JvmName("qxbckuufbvymbemk")
    public suspend fun instanceNumber(`value`: Output<String>) {
        this.instanceNumber = value
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("rqilwkvruyhtgghd")
    public suspend
    fun recoveryServicesVault(`value`: Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>) {
        this.recoveryServicesVault = value
    }

    /**
     * @param value Path of the SSL key store.
     */
    @JvmName("hvnodgbjsvuhboot")
    public suspend fun sslConfiguration(`value`: Output<SSLConfigurationArgs>) {
        this.sslConfiguration = value
    }

    /**
     * @param value Defines the policy properties for database backup.
     */
    @JvmName("ajfsnotvpcugbcae")
    public suspend fun backupPolicy(`value`: DBBackupPolicyPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPolicy = mapped
    }

    /**
     * @param argument Defines the policy properties for database backup.
     */
    @JvmName("upfiyenlsfqiyauk")
    public suspend
    fun backupPolicy(argument: suspend DBBackupPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DBBackupPolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupPolicy = mapped
    }

    /**
     * @param value The type of backup, VM, SQL or HANA.
     * Expected value is 'HANA'.
     */
    @JvmName("cwluebonirhlspit")
    public suspend fun backupType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value Defines the policy properties for database backup.
     */
    @JvmName("nbwypopuaillsweo")
    public suspend fun dbInstanceSnapshotBackupPolicy(`value`: DBBackupPolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceSnapshotBackupPolicy = mapped
    }

    /**
     * @param argument Defines the policy properties for database backup.
     */
    @JvmName("todmqxtejixyjpib")
    public suspend
    fun dbInstanceSnapshotBackupPolicy(argument: suspend DBBackupPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DBBackupPolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dbInstanceSnapshotBackupPolicy = mapped
    }

    /**
     * @param value Name of the HANA Database User Store Key.
     */
    @JvmName("buduunhyvjtxeabf")
    public suspend fun hdbuserstoreKeyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hdbuserstoreKeyName = mapped
    }

    /**
     * @param value Gets or sets the database instance number.
     */
    @JvmName("mylvmstcvfaqmmqb")
    public suspend fun instanceNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceNumber = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("qyeukrbobghptles")
    public suspend
    fun recoveryServicesVault(`value`: Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("proakvhcuwyiqwgm")
    public fun recoveryServicesVault(`value`: ExistingRecoveryServicesVaultArgs) {
        val toBeMapped = Either.ofLeft<ExistingRecoveryServicesVaultArgs,
            NewRecoveryServicesVaultArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("ccapnkehjdxbowel")
    public fun recoveryServicesVault(`value`: NewRecoveryServicesVaultArgs) {
        val toBeMapped = Either.ofRight<ExistingRecoveryServicesVaultArgs,
            NewRecoveryServicesVaultArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    /**
     * @param value Path of the SSL key store.
     */
    @JvmName("kqdkybckkbpkcolw")
    public suspend fun sslConfiguration(`value`: SSLConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslConfiguration = mapped
    }

    /**
     * @param argument Path of the SSL key store.
     */
    @JvmName("sjjvgukembhvwtcq")
    public suspend fun sslConfiguration(argument: suspend SSLConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = SSLConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslConfiguration = mapped
    }

    internal fun build(): HanaBackupDataArgs = HanaBackupDataArgs(
        backupPolicy = backupPolicy ?: throw PulumiNullFieldException("backupPolicy"),
        backupType = backupType ?: throw PulumiNullFieldException("backupType"),
        dbInstanceSnapshotBackupPolicy = dbInstanceSnapshotBackupPolicy,
        hdbuserstoreKeyName = hdbuserstoreKeyName ?: throw PulumiNullFieldException("hdbuserstoreKeyName"),
        instanceNumber = instanceNumber,
        recoveryServicesVault = recoveryServicesVault ?: throw
            PulumiNullFieldException("recoveryServicesVault"),
        sslConfiguration = sslConfiguration,
    )
}
