@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.LogSchedulePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Log policy schedule.
 * @property scheduleFrequencyInMins Frequency of the log schedule operation of this policy in minutes.
 * @property schedulePolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'LogSchedulePolicy'.
 */
public data class LogSchedulePolicyArgs(
    public val scheduleFrequencyInMins: Output<Int>? = null,
    public val schedulePolicyType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.LogSchedulePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.LogSchedulePolicyArgs =
        com.pulumi.azurenative.workloads.inputs.LogSchedulePolicyArgs.builder()
            .scheduleFrequencyInMins(scheduleFrequencyInMins?.applyValue({ args0 -> args0 }))
            .schedulePolicyType(schedulePolicyType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogSchedulePolicyArgs].
 */
@PulumiTagMarker
public class LogSchedulePolicyArgsBuilder internal constructor() {
    private var scheduleFrequencyInMins: Output<Int>? = null

    private var schedulePolicyType: Output<String>? = null

    /**
     * @param value Frequency of the log schedule operation of this policy in minutes.
     */
    @JvmName("jhfrwtyjehgkiqtg")
    public suspend fun scheduleFrequencyInMins(`value`: Output<Int>) {
        this.scheduleFrequencyInMins = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'LogSchedulePolicy'.
     */
    @JvmName("kykgqrkmwaifqcrq")
    public suspend fun schedulePolicyType(`value`: Output<String>) {
        this.schedulePolicyType = value
    }

    /**
     * @param value Frequency of the log schedule operation of this policy in minutes.
     */
    @JvmName("vwhggtxwvnkjiueb")
    public suspend fun scheduleFrequencyInMins(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleFrequencyInMins = mapped
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'LogSchedulePolicy'.
     */
    @JvmName("mrmavxfbdkwdaaes")
    public suspend fun schedulePolicyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedulePolicyType = mapped
    }

    internal fun build(): LogSchedulePolicyArgs = LogSchedulePolicyArgs(
        scheduleFrequencyInMins = scheduleFrequencyInMins,
        schedulePolicyType = schedulePolicyType ?: throw PulumiNullFieldException("schedulePolicyType"),
    )
}
