@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.MonthlyRetentionScheduleArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.RetentionScheduleFormat
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Monthly retention schedule.
 * @property retentionDuration Retention duration of retention Policy.
 * @property retentionScheduleDaily Daily retention format for monthly retention policy.
 * @property retentionScheduleFormatType Retention schedule format type for monthly retention policy.
 * @property retentionScheduleWeekly Weekly retention format for monthly retention policy.
 * @property retentionTimes Retention times of retention policy.
 */
public data class MonthlyRetentionScheduleArgs(
    public val retentionDuration: Output<RetentionDurationArgs>? = null,
    public val retentionScheduleDaily: Output<DailyRetentionFormatArgs>? = null,
    public val retentionScheduleFormatType: Output<Either<String, RetentionScheduleFormat>>? = null,
    public val retentionScheduleWeekly: Output<WeeklyRetentionFormatArgs>? = null,
    public val retentionTimes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.MonthlyRetentionScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.MonthlyRetentionScheduleArgs =
        com.pulumi.azurenative.workloads.inputs.MonthlyRetentionScheduleArgs.builder()
            .retentionDuration(retentionDuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retentionScheduleDaily(
                retentionScheduleDaily?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retentionScheduleFormatType(
                retentionScheduleFormatType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .retentionScheduleWeekly(
                retentionScheduleWeekly?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retentionTimes(retentionTimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [MonthlyRetentionScheduleArgs].
 */
@PulumiTagMarker
public class MonthlyRetentionScheduleArgsBuilder internal constructor() {
    private var retentionDuration: Output<RetentionDurationArgs>? = null

    private var retentionScheduleDaily: Output<DailyRetentionFormatArgs>? = null

    private var retentionScheduleFormatType: Output<Either<String, RetentionScheduleFormat>>? = null

    private var retentionScheduleWeekly: Output<WeeklyRetentionFormatArgs>? = null

    private var retentionTimes: Output<List<String>>? = null

    /**
     * @param value Retention duration of retention Policy.
     */
    @JvmName("luowqdsooupppycy")
    public suspend fun retentionDuration(`value`: Output<RetentionDurationArgs>) {
        this.retentionDuration = value
    }

    /**
     * @param value Daily retention format for monthly retention policy.
     */
    @JvmName("iacthjbmjqrkxjdf")
    public suspend fun retentionScheduleDaily(`value`: Output<DailyRetentionFormatArgs>) {
        this.retentionScheduleDaily = value
    }

    /**
     * @param value Retention schedule format type for monthly retention policy.
     */
    @JvmName("itlidfadbapxkuiu")
    public suspend
    fun retentionScheduleFormatType(`value`: Output<Either<String, RetentionScheduleFormat>>) {
        this.retentionScheduleFormatType = value
    }

    /**
     * @param value Weekly retention format for monthly retention policy.
     */
    @JvmName("aycoeinrjpsnsmsv")
    public suspend fun retentionScheduleWeekly(`value`: Output<WeeklyRetentionFormatArgs>) {
        this.retentionScheduleWeekly = value
    }

    /**
     * @param value Retention times of retention policy.
     */
    @JvmName("sxeyobxnxkjatoax")
    public suspend fun retentionTimes(`value`: Output<List<String>>) {
        this.retentionTimes = value
    }

    @JvmName("obramyumdysvftqf")
    public suspend fun retentionTimes(vararg values: Output<String>) {
        this.retentionTimes = Output.all(values.asList())
    }

    /**
     * @param values Retention times of retention policy.
     */
    @JvmName("ckvbebggbyrhdlmj")
    public suspend fun retentionTimes(values: List<Output<String>>) {
        this.retentionTimes = Output.all(values)
    }

    /**
     * @param value Retention duration of retention Policy.
     */
    @JvmName("msmcaaguxjeaseke")
    public suspend fun retentionDuration(`value`: RetentionDurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDuration = mapped
    }

    /**
     * @param argument Retention duration of retention Policy.
     */
    @JvmName("uwknggyvoqhtsksg")
    public suspend fun retentionDuration(argument: suspend RetentionDurationArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionDurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionDuration = mapped
    }

    /**
     * @param value Daily retention format for monthly retention policy.
     */
    @JvmName("ibgwfhkmrucwxeof")
    public suspend fun retentionScheduleDaily(`value`: DailyRetentionFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionScheduleDaily = mapped
    }

    /**
     * @param argument Daily retention format for monthly retention policy.
     */
    @JvmName("pubeatrsbsgowcgd")
    public suspend
    fun retentionScheduleDaily(argument: suspend DailyRetentionFormatArgsBuilder.() -> Unit) {
        val toBeMapped = DailyRetentionFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionScheduleDaily = mapped
    }

    /**
     * @param value Retention schedule format type for monthly retention policy.
     */
    @JvmName("rnhopdwaokbddves")
    public suspend
    fun retentionScheduleFormatType(`value`: Either<String, RetentionScheduleFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionScheduleFormatType = mapped
    }

    /**
     * @param value Retention schedule format type for monthly retention policy.
     */
    @JvmName("lggpdaxieswgtpgf")
    public fun retentionScheduleFormatType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RetentionScheduleFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionScheduleFormatType = mapped
    }

    /**
     * @param value Retention schedule format type for monthly retention policy.
     */
    @JvmName("opglhsidtcfoebnh")
    public fun retentionScheduleFormatType(`value`: RetentionScheduleFormat) {
        val toBeMapped = Either.ofRight<String, RetentionScheduleFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionScheduleFormatType = mapped
    }

    /**
     * @param value Weekly retention format for monthly retention policy.
     */
    @JvmName("asrbrgwcfgpblmsy")
    public suspend fun retentionScheduleWeekly(`value`: WeeklyRetentionFormatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionScheduleWeekly = mapped
    }

    /**
     * @param argument Weekly retention format for monthly retention policy.
     */
    @JvmName("icghrjufiqxwdhnv")
    public suspend
    fun retentionScheduleWeekly(argument: suspend WeeklyRetentionFormatArgsBuilder.() -> Unit) {
        val toBeMapped = WeeklyRetentionFormatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionScheduleWeekly = mapped
    }

    /**
     * @param value Retention times of retention policy.
     */
    @JvmName("ocrwhfwgmwxwsxbv")
    public suspend fun retentionTimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionTimes = mapped
    }

    /**
     * @param values Retention times of retention policy.
     */
    @JvmName("mtbyhlcyxirjqmga")
    public suspend fun retentionTimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionTimes = mapped
    }

    internal fun build(): MonthlyRetentionScheduleArgs = MonthlyRetentionScheduleArgs(
        retentionDuration = retentionDuration,
        retentionScheduleDaily = retentionScheduleDaily,
        retentionScheduleFormatType = retentionScheduleFormatType,
        retentionScheduleWeekly = retentionScheduleWeekly,
        retentionTimes = retentionTimes,
    )
}
