@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.NetworkConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the network configuration type for SAP system infrastructure that is being deployed
 * @property isSecondaryIpEnabled Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
 */
public data class NetworkConfigurationArgs(
    public val isSecondaryIpEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.NetworkConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.NetworkConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.NetworkConfigurationArgs.builder()
            .isSecondaryIpEnabled(isSecondaryIpEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkConfigurationArgs].
 */
@PulumiTagMarker
public class NetworkConfigurationArgsBuilder internal constructor() {
    private var isSecondaryIpEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
     */
    @JvmName("qjeibswmbuscebwv")
    public suspend fun isSecondaryIpEnabled(`value`: Output<Boolean>) {
        this.isSecondaryIpEnabled = value
    }

    /**
     * @param value Specifies whether a secondary IP address should be added to the network interface on all VMs of the SAP system being deployed
     */
    @JvmName("fruvebxgjbirbyeo")
    public suspend fun isSecondaryIpEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSecondaryIpEnabled = mapped
    }

    internal fun build(): NetworkConfigurationArgs = NetworkConfigurationArgs(
        isSecondaryIpEnabled = isSecondaryIpEnabled,
    )
}
