@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.NetworkInterfaceResourceNamesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The resource names object for network interface and related resources.
 * @property networkInterfaceName The full name for network interface. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
 */
public data class NetworkInterfaceResourceNamesArgs(
    public val networkInterfaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.NetworkInterfaceResourceNamesArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.NetworkInterfaceResourceNamesArgs =
        com.pulumi.azurenative.workloads.inputs.NetworkInterfaceResourceNamesArgs.builder()
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceResourceNamesArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceResourceNamesArgsBuilder internal constructor() {
    private var networkInterfaceName: Output<String>? = null

    /**
     * @param value The full name for network interface. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
     */
    @JvmName("sishwieprdfwgfuf")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value The full name for network interface. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
     */
    @JvmName("isctxhabfvytcksf")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    internal fun build(): NetworkInterfaceResourceNamesArgs = NetworkInterfaceResourceNamesArgs(
        networkInterfaceName = networkInterfaceName,
    )
}
