@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.NewRecoveryServicesVaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * New recovery services vault.
 * @property name The name of the recovery services vault has to be created.
 * @property resourceGroup The name of the resource group where the recovery services vault has to be created.
 * @property vaultType The vault type, whether it is existing or has to be created.
 * Expected value is 'New'.
 */
public data class NewRecoveryServicesVaultArgs(
    public val name: Output<String>,
    public val resourceGroup: Output<String>,
    public val vaultType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.NewRecoveryServicesVaultArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.NewRecoveryServicesVaultArgs =
        com.pulumi.azurenative.workloads.inputs.NewRecoveryServicesVaultArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup.applyValue({ args0 -> args0 }))
            .vaultType(vaultType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NewRecoveryServicesVaultArgs].
 */
@PulumiTagMarker
public class NewRecoveryServicesVaultArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var vaultType: Output<String>? = null

    /**
     * @param value The name of the recovery services vault has to be created.
     */
    @JvmName("lenorvtrelcbddwp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault has to be created.
     */
    @JvmName("wxvjybmnabstwpoh")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The vault type, whether it is existing or has to be created.
     * Expected value is 'New'.
     */
    @JvmName("xhwyfhdimafcshcw")
    public suspend fun vaultType(`value`: Output<String>) {
        this.vaultType = value
    }

    /**
     * @param value The name of the recovery services vault has to be created.
     */
    @JvmName("srljiyqfjpuueyjt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault has to be created.
     */
    @JvmName("imbnrbvlqjbqbdgo")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The vault type, whether it is existing or has to be created.
     * Expected value is 'New'.
     */
    @JvmName("bojpnsbefwdhsrro")
    public suspend fun vaultType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultType = mapped
    }

    internal fun build(): NewRecoveryServicesVaultArgs = NewRecoveryServicesVaultArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
        vaultType = vaultType ?: throw PulumiNullFieldException("vaultType"),
    )
}
