@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.RetentionDurationArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.RetentionDurationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Retention duration.
 * @property count Count of duration types. Retention duration is obtained by the counting the duration type Count times.
 * For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
 * @property durationType Retention duration type of retention policy.
 */
public data class RetentionDurationArgs(
    public val count: Output<Int>? = null,
    public val durationType: Output<Either<String, RetentionDurationType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.RetentionDurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.RetentionDurationArgs =
        com.pulumi.azurenative.workloads.inputs.RetentionDurationArgs.builder()
            .count(count?.applyValue({ args0 -> args0 }))
            .durationType(
                durationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RetentionDurationArgs].
 */
@PulumiTagMarker
public class RetentionDurationArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var durationType: Output<Either<String, RetentionDurationType>>? = null

    /**
     * @param value Count of duration types. Retention duration is obtained by the counting the duration type Count times.
     * For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
     */
    @JvmName("iwuueexvapxmspfd")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value Retention duration type of retention policy.
     */
    @JvmName("rbparnnyawyibebw")
    public suspend fun durationType(`value`: Output<Either<String, RetentionDurationType>>) {
        this.durationType = value
    }

    /**
     * @param value Count of duration types. Retention duration is obtained by the counting the duration type Count times.
     * For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
     */
    @JvmName("utrwrbtmtgitlran")
    public suspend fun count(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value Retention duration type of retention policy.
     */
    @JvmName("yprlmapbyljbhpml")
    public suspend fun durationType(`value`: Either<String, RetentionDurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.durationType = mapped
    }

    /**
     * @param value Retention duration type of retention policy.
     */
    @JvmName("cgxyjtixgwebwlhn")
    public fun durationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RetentionDurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.durationType = mapped
    }

    /**
     * @param value Retention duration type of retention policy.
     */
    @JvmName("pxurcrhwlxiuycbq")
    public fun durationType(`value`: RetentionDurationType) {
        val toBeMapped = Either.ofRight<String, RetentionDurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.durationType = mapped
    }

    internal fun build(): RetentionDurationArgs = RetentionDurationArgs(
        count = count,
        durationType = durationType,
    )
}
