@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.SSLConfigurationArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.SslCryptoProvider
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specify the HANA database TLS/SSL properties which will be used for enabling Azure Backup for this database. You need to specify these details if you have enabled secure communication for your HANA database.
 * @property sslCryptoProvider Specify the crypto provider being used (commoncrypto/openssl). If this argument is not provided, it is automatically determined by searching in the configuration files.
 * @property sslHostNameInCertificate Specify the hostname as mentioned in the SSL certificate. If this argument is not provided, it is automatically determined by searching in the SSL certificate.
 * @property sslKeyStore Specify the name of the keystore file that contains the client's identity (eg. sapsrv.pse). The script will search for the file in the appropriate directory depending on the crypto provider mentioned. If this argument is not provided, it is automatically determined by searching in the configuration files.
 * @property sslTrustStore Specify the name of the trust store file that contains the server’s public certificates (eg. sapsrv.pse). The script will search for the file in the appropriate directory depending on the crypto provider mentioned. If this argument is not provided, it is automatically determined by searching in the configuration files.
 */
public data class SSLConfigurationArgs(
    public val sslCryptoProvider: Output<Either<String, SslCryptoProvider>>? = null,
    public val sslHostNameInCertificate: Output<String>? = null,
    public val sslKeyStore: Output<String>? = null,
    public val sslTrustStore: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.SSLConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.SSLConfigurationArgs =
        com.pulumi.azurenative.workloads.inputs.SSLConfigurationArgs.builder()
            .sslCryptoProvider(
                sslCryptoProvider?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .sslHostNameInCertificate(sslHostNameInCertificate?.applyValue({ args0 -> args0 }))
            .sslKeyStore(sslKeyStore?.applyValue({ args0 -> args0 }))
            .sslTrustStore(sslTrustStore?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SSLConfigurationArgs].
 */
@PulumiTagMarker
public class SSLConfigurationArgsBuilder internal constructor() {
    private var sslCryptoProvider: Output<Either<String, SslCryptoProvider>>? = null

    private var sslHostNameInCertificate: Output<String>? = null

    private var sslKeyStore: Output<String>? = null

    private var sslTrustStore: Output<String>? = null

    /**
     * @param value Specify the crypto provider being used (commoncrypto/openssl). If this argument is not provided, it is automatically determined by searching in the configuration files.
     */
    @JvmName("fjhunstwdeoyxbap")
    public suspend fun sslCryptoProvider(`value`: Output<Either<String, SslCryptoProvider>>) {
        this.sslCryptoProvider = value
    }

    /**
     * @param value Specify the hostname as mentioned in the SSL certificate. If this argument is not provided, it is automatically determined by searching in the SSL certificate.
     */
    @JvmName("cxopmcaajmxjytmf")
    public suspend fun sslHostNameInCertificate(`value`: Output<String>) {
        this.sslHostNameInCertificate = value
    }

    /**
     * @param value Specify the name of the keystore file that contains the client's identity (eg. sapsrv.pse). The script will search for the file in the appropriate directory depending on the crypto provider mentioned. If this argument is not provided, it is automatically determined by searching in the configuration files.
     */
    @JvmName("sutylhdkdhsjhwff")
    public suspend fun sslKeyStore(`value`: Output<String>) {
        this.sslKeyStore = value
    }

    /**
     * @param value Specify the name of the trust store file that contains the server’s public certificates (eg. sapsrv.pse). The script will search for the file in the appropriate directory depending on the crypto provider mentioned. If this argument is not provided, it is automatically determined by searching in the configuration files.
     */
    @JvmName("ryorsbfdcbilxgua")
    public suspend fun sslTrustStore(`value`: Output<String>) {
        this.sslTrustStore = value
    }

    /**
     * @param value Specify the crypto provider being used (commoncrypto/openssl). If this argument is not provided, it is automatically determined by searching in the configuration files.
     */
    @JvmName("rbhsuvtghkoudskx")
    public suspend fun sslCryptoProvider(`value`: Either<String, SslCryptoProvider>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCryptoProvider = mapped
    }

    /**
     * @param value Specify the crypto provider being used (commoncrypto/openssl). If this argument is not provided, it is automatically determined by searching in the configuration files.
     */
    @JvmName("ivvqxneuflmswadi")
    public fun sslCryptoProvider(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SslCryptoProvider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslCryptoProvider = mapped
    }

    /**
     * @param value Specify the crypto provider being used (commoncrypto/openssl). If this argument is not provided, it is automatically determined by searching in the configuration files.
     */
    @JvmName("plrmwymldpsbitmc")
    public fun sslCryptoProvider(`value`: SslCryptoProvider) {
        val toBeMapped = Either.ofRight<String, SslCryptoProvider>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sslCryptoProvider = mapped
    }

    /**
     * @param value Specify the hostname as mentioned in the SSL certificate. If this argument is not provided, it is automatically determined by searching in the SSL certificate.
     */
    @JvmName("woglrusprpajilsw")
    public suspend fun sslHostNameInCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslHostNameInCertificate = mapped
    }

    /**
     * @param value Specify the name of the keystore file that contains the client's identity (eg. sapsrv.pse). The script will search for the file in the appropriate directory depending on the crypto provider mentioned. If this argument is not provided, it is automatically determined by searching in the configuration files.
     */
    @JvmName("mwpygkuwgovabiuw")
    public suspend fun sslKeyStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslKeyStore = mapped
    }

    /**
     * @param value Specify the name of the trust store file that contains the server’s public certificates (eg. sapsrv.pse). The script will search for the file in the appropriate directory depending on the crypto provider mentioned. If this argument is not provided, it is automatically determined by searching in the configuration files.
     */
    @JvmName("esbftukujgumqtyi")
    public suspend fun sslTrustStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslTrustStore = mapped
    }

    internal fun build(): SSLConfigurationArgs = SSLConfigurationArgs(
        sslCryptoProvider = sslCryptoProvider,
        sslHostNameInCertificate = sslHostNameInCertificate,
        sslKeyStore = sslKeyStore,
        sslTrustStore = sslTrustStore,
    )
}
