@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.WeeklyRetentionScheduleArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.DayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Weekly retention schedule.
 * @property daysOfTheWeek List of days of week for weekly retention policy.
 * @property retentionDuration Retention duration of retention Policy.
 * @property retentionTimes Retention times of retention policy.
 */
public data class WeeklyRetentionScheduleArgs(
    public val daysOfTheWeek: Output<List<DayOfWeek>>? = null,
    public val retentionDuration: Output<RetentionDurationArgs>? = null,
    public val retentionTimes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.WeeklyRetentionScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.WeeklyRetentionScheduleArgs =
        com.pulumi.azurenative.workloads.inputs.WeeklyRetentionScheduleArgs.builder()
            .daysOfTheWeek(
                daysOfTheWeek?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .retentionDuration(retentionDuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .retentionTimes(retentionTimes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WeeklyRetentionScheduleArgs].
 */
@PulumiTagMarker
public class WeeklyRetentionScheduleArgsBuilder internal constructor() {
    private var daysOfTheWeek: Output<List<DayOfWeek>>? = null

    private var retentionDuration: Output<RetentionDurationArgs>? = null

    private var retentionTimes: Output<List<String>>? = null

    /**
     * @param value List of days of week for weekly retention policy.
     */
    @JvmName("vgxsrohvcaaavfjd")
    public suspend fun daysOfTheWeek(`value`: Output<List<DayOfWeek>>) {
        this.daysOfTheWeek = value
    }

    @JvmName("dmtwimoeettmqiqx")
    public suspend fun daysOfTheWeek(vararg values: Output<DayOfWeek>) {
        this.daysOfTheWeek = Output.all(values.asList())
    }

    /**
     * @param values List of days of week for weekly retention policy.
     */
    @JvmName("bxisbelapxrcgabu")
    public suspend fun daysOfTheWeek(values: List<Output<DayOfWeek>>) {
        this.daysOfTheWeek = Output.all(values)
    }

    /**
     * @param value Retention duration of retention Policy.
     */
    @JvmName("nrardfudkehwkktn")
    public suspend fun retentionDuration(`value`: Output<RetentionDurationArgs>) {
        this.retentionDuration = value
    }

    /**
     * @param value Retention times of retention policy.
     */
    @JvmName("ggrpnvbekqgvdsok")
    public suspend fun retentionTimes(`value`: Output<List<String>>) {
        this.retentionTimes = value
    }

    @JvmName("hpyxhupbuhhxvtmc")
    public suspend fun retentionTimes(vararg values: Output<String>) {
        this.retentionTimes = Output.all(values.asList())
    }

    /**
     * @param values Retention times of retention policy.
     */
    @JvmName("avorvkrymborlele")
    public suspend fun retentionTimes(values: List<Output<String>>) {
        this.retentionTimes = Output.all(values)
    }

    /**
     * @param value List of days of week for weekly retention policy.
     */
    @JvmName("lruubysthkamgnee")
    public suspend fun daysOfTheWeek(`value`: List<DayOfWeek>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.daysOfTheWeek = mapped
    }

    /**
     * @param values List of days of week for weekly retention policy.
     */
    @JvmName("kkeichigypdmonbb")
    public suspend fun daysOfTheWeek(vararg values: DayOfWeek) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.daysOfTheWeek = mapped
    }

    /**
     * @param value Retention duration of retention Policy.
     */
    @JvmName("dxvoumfagvfxcncj")
    public suspend fun retentionDuration(`value`: RetentionDurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDuration = mapped
    }

    /**
     * @param argument Retention duration of retention Policy.
     */
    @JvmName("qatcdvjwbegfjpjv")
    public suspend fun retentionDuration(argument: suspend RetentionDurationArgsBuilder.() -> Unit) {
        val toBeMapped = RetentionDurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionDuration = mapped
    }

    /**
     * @param value Retention times of retention policy.
     */
    @JvmName("bgvifgxsndvmqdkk")
    public suspend fun retentionTimes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionTimes = mapped
    }

    /**
     * @param values Retention times of retention policy.
     */
    @JvmName("isxlbwcbdirjcohb")
    public suspend fun retentionTimes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionTimes = mapped
    }

    internal fun build(): WeeklyRetentionScheduleArgs = WeeklyRetentionScheduleArgs(
        daysOfTheWeek = daysOfTheWeek,
        retentionDuration = retentionDuration,
        retentionTimes = retentionTimes,
    )
}
