@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the DB2 provider properties.
 * @property dbName Gets or sets the db2 database name.
 * @property dbPassword Gets or sets the db2 database password.
 * @property dbPasswordUri Gets or sets the key vault URI to secret with the database password.
 * @property dbPort Gets or sets the db2 database sql port.
 * @property dbUsername Gets or sets the db2 database user name.
 * @property hostname Gets or sets the target virtual machine name.
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'Db2'.
 * @property sapSid Gets or sets the SAP System Identifier
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the DB2 Database.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class DB2ProviderInstancePropertiesResponse(
    public val dbName: String? = null,
    public val dbPassword: String? = null,
    public val dbPasswordUri: String? = null,
    public val dbPort: String? = null,
    public val dbUsername: String? = null,
    public val hostname: String? = null,
    public val providerType: String,
    public val sapSid: String? = null,
    public val sslCertificateUri: String? = null,
    public val sslPreference: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DB2ProviderInstancePropertiesResponse):
            DB2ProviderInstancePropertiesResponse = DB2ProviderInstancePropertiesResponse(
            dbName = javaType.dbName().map({ args0 -> args0 }).orElse(null),
            dbPassword = javaType.dbPassword().map({ args0 -> args0 }).orElse(null),
            dbPasswordUri = javaType.dbPasswordUri().map({ args0 -> args0 }).orElse(null),
            dbPort = javaType.dbPort().map({ args0 -> args0 }).orElse(null),
            dbUsername = javaType.dbUsername().map({ args0 -> args0 }).orElse(null),
            hostname = javaType.hostname().map({ args0 -> args0 }).orElse(null),
            providerType = javaType.providerType(),
            sapSid = javaType.sapSid().map({ args0 -> args0 }).orElse(null),
            sslCertificateUri = javaType.sslCertificateUri().map({ args0 -> args0 }).orElse(null),
            sslPreference = javaType.sslPreference().map({ args0 -> args0 }).orElse(null),
        )
    }
}
