@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The Disk Configuration Details.
 * @property diskVolumeConfigurations The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
 */
public data class DiskConfigurationResponse(
    public val diskVolumeConfigurations: Map<String, DiskVolumeConfigurationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DiskConfigurationResponse):
            DiskConfigurationResponse = DiskConfigurationResponse(
            diskVolumeConfigurations = javaType.diskVolumeConfigurations().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.DiskVolumeConfigurationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
