@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The supported disk size details for a disk type.
 * @property diskTier The disk tier, e.g. P10, E10.
 * @property iopsReadWrite The disk Iops.
 * @property maximumSupportedDiskCount The maximum supported disk count.
 * @property mbpsReadWrite The disk provisioned throughput in MBps.
 * @property minimumSupportedDiskCount The minimum supported disk count.
 * @property sizeGB The disk size in GB.
 * @property sku The type of disk sku. For example, Standard_LRS, Standard_ZRS, Premium_LRS, Premium_ZRS.
 */
public data class DiskDetailsResponse(
    public val diskTier: String? = null,
    public val iopsReadWrite: Double? = null,
    public val maximumSupportedDiskCount: Double? = null,
    public val mbpsReadWrite: Double? = null,
    public val minimumSupportedDiskCount: Double? = null,
    public val sizeGB: Double? = null,
    public val sku: DiskSkuResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DiskDetailsResponse):
            DiskDetailsResponse = DiskDetailsResponse(
            diskTier = javaType.diskTier().map({ args0 -> args0 }).orElse(null),
            iopsReadWrite = javaType.iopsReadWrite().map({ args0 -> args0 }).orElse(null),
            maximumSupportedDiskCount = javaType.maximumSupportedDiskCount().map({ args0 ->
                args0
            }).orElse(null),
            mbpsReadWrite = javaType.mbpsReadWrite().map({ args0 -> args0 }).orElse(null),
            minimumSupportedDiskCount = javaType.minimumSupportedDiskCount().map({ args0 ->
                args0
            }).orElse(null),
            sizeGB = javaType.sizeGB().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DiskSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
