@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the SAP Enqueue Replication Server (ERS) properties.
 * @property ersVersion Defines the type of Enqueue Replication Server.
 * @property health Defines the health of SAP Instances.
 * @property hostname ERS SAP Hostname.
 * @property instanceNo ERS Instance Number.
 * @property ipAddress ERS SAP IP Address.
 * @property kernelPatch ERS SAP Kernel Patch level.
 * @property kernelVersion ERS SAP Kernel Version.
 */
public data class EnqueueReplicationServerPropertiesResponse(
    public val ersVersion: String,
    public val health: String,
    public val hostname: String,
    public val instanceNo: String,
    public val ipAddress: String,
    public val kernelPatch: String,
    public val kernelVersion: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.EnqueueReplicationServerPropertiesResponse):
            EnqueueReplicationServerPropertiesResponse = EnqueueReplicationServerPropertiesResponse(
            ersVersion = javaType.ersVersion(),
            health = javaType.health(),
            hostname = javaType.hostname(),
            instanceNo = javaType.instanceNo(),
            ipAddress = javaType.ipAddress(),
            kernelPatch = javaType.kernelPatch(),
            kernelVersion = javaType.kernelVersion(),
        )
    }
}
