@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Define the connector resource.
 * @property errors Indicates any errors on the connector resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Managed service identity (user assigned identities)
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration Managed resource group configuration
 * @property name The name of the resource
 * @property provisioningState Defines the provisioning states.
 * @property sourceResourceId Defines the ID of the connector's source resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetConnectorResult(
    public val errors: ConnectorErrorDefinitionResponse,
    public val id: String,
    public val identity: UserAssignedServiceIdentityResponse? = null,
    public val location: String,
    public val managedResourceGroupConfiguration: ManagedRGConfigurationResponse? = null,
    public val name: String,
    public val provisioningState: String,
    public val sourceResourceId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetConnectorResult):
            GetConnectorResult = GetConnectorResult(
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.ConnectorErrorDefinitionResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ManagedRGConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            sourceResourceId = javaType.sourceResourceId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
