@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The list of disk configuration for vmSku which are part of SAP deployment.
 * @property volumeConfigurations The disk configuration for the db volume. For HANA, Required volumes are: ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os'], Optional volume : ['backup'].
 */
public data class GetSAPDiskConfigurationsResult(
    public val volumeConfigurations: Map<String, SAPDiskConfigurationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSAPDiskConfigurationsResult):
            GetSAPDiskConfigurationsResult = GetSAPDiskConfigurationsResult(
            volumeConfigurations = javaType.volumeConfigurations().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.SAPDiskConfigurationResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
