@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SAP sizing recommendation result.
 * @property deploymentType The type of SAP deployment, single server or Three tier.
 */
public data class GetSAPSizingRecommendationsResult(
    public val deploymentType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSAPSizingRecommendationsResult):
            GetSAPSizingRecommendationsResult = GetSAPSizingRecommendationsResult(
            deploymentType = javaType.deploymentType(),
        )
    }
}
