@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Defines the HANA Backup data for a virtual instance for SAP.
 * @property backupPolicy Defines the policy properties for database backup.
 * @property backupType The type of backup, VM, SQL or HANA.
 * Expected value is 'HANA'.
 * @property dbInstanceSnapshotBackupPolicy Defines the policy properties for database backup.
 * @property hdbuserstoreKeyName Name of the HANA Database User Store Key.
 * @property instanceNumber Gets or sets the database instance number.
 * @property recoveryServicesVault The properties of the recovery services vault used for backup.
 * @property sslConfiguration Path of the SSL key store.
 */
public data class HanaBackupDataResponse(
    public val backupPolicy: DBBackupPolicyPropertiesResponse,
    public val backupType: String,
    public val dbInstanceSnapshotBackupPolicy: DBBackupPolicyPropertiesResponse? = null,
    public val hdbuserstoreKeyName: String,
    public val instanceNumber: String? = null,
    public val recoveryServicesVault:
    Either<ExistingRecoveryServicesVaultResponse, NewRecoveryServicesVaultResponse>,
    public val sslConfiguration: SSLConfigurationResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.HanaBackupDataResponse):
            HanaBackupDataResponse = HanaBackupDataResponse(
            backupPolicy = javaType.backupPolicy().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.DBBackupPolicyPropertiesResponse.Companion.toKotlin(args0)
            }),
            backupType = javaType.backupType(),
            dbInstanceSnapshotBackupPolicy = javaType.dbInstanceSnapshotBackupPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DBBackupPolicyPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hdbuserstoreKeyName = javaType.hdbuserstoreKeyName(),
            instanceNumber = javaType.instanceNumber().map({ args0 -> args0 }).orElse(null),
            recoveryServicesVault = javaType.recoveryServicesVault().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.ExistingRecoveryServicesVaultResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.NewRecoveryServicesVaultResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            sslConfiguration = javaType.sslConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SSLConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
