@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource names object for network interface and related resources.
 * @property networkInterfaceName The full name for network interface. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}-Nic. In case of HA-AvZone systems, default name will be {SID}-{App/ASCS/DB}-Zone{A/B}-Nic with an incrementor at the end in case of more than 1 instance per layer. For distributed and HA-AvSet systems, default name will be {SID}-{App/ASCS/DB}-Nic with an incrementor at the end in case of more than 1 instance per layer.
 */
public data class NetworkInterfaceResourceNamesResponse(
    public val networkInterfaceName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.NetworkInterfaceResourceNamesResponse):
            NetworkInterfaceResourceNamesResponse = NetworkInterfaceResourceNamesResponse(
            networkInterfaceName = javaType.networkInterfaceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
