@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the PrometheusHaCluster provider properties.
 * @property clusterName Gets or sets the clusterName.
 * @property hostname Gets or sets the target machine name.
 * @property prometheusUrl URL of the Node Exporter endpoint.
 * @property providerType The provider type. For example, the value can be SapHana.
 * Expected value is 'PrometheusHaCluster'.
 * @property sid Gets or sets the cluster sid.
 * @property sslCertificateUri Gets or sets the blob URI to SSL certificate for the HA cluster exporter.
 * @property sslPreference Gets or sets certificate preference if secure communication is enabled.
 */
public data class PrometheusHaClusterProviderInstancePropertiesResponse(
    public val clusterName: String? = null,
    public val hostname: String? = null,
    public val prometheusUrl: String? = null,
    public val providerType: String,
    public val sid: String? = null,
    public val sslCertificateUri: String? = null,
    public val sslPreference: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.PrometheusHaClusterProviderInstancePropertiesResponse):
            PrometheusHaClusterProviderInstancePropertiesResponse =
            PrometheusHaClusterProviderInstancePropertiesResponse(
                clusterName = javaType.clusterName().map({ args0 -> args0 }).orElse(null),
                hostname = javaType.hostname().map({ args0 -> args0 }).orElse(null),
                prometheusUrl = javaType.prometheusUrl().map({ args0 -> args0 }).orElse(null),
                providerType = javaType.providerType(),
                sid = javaType.sid().map({ args0 -> args0 }).orElse(null),
                sslCertificateUri = javaType.sslCertificateUri().map({ args0 -> args0 }).orElse(null),
                sslPreference = javaType.sslPreference().map({ args0 -> args0 }).orElse(null),
            )
    }
}
