@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The SAP Disk Configuration contains 'recommended disk' details and list of supported disks detail for a volume type.
 * @property recommendedConfiguration The recommended disk details for a given VM Sku.
 * @property supportedConfigurations The list of supported disks for a given VM Sku.
 */
public data class SAPDiskConfigurationResponse(
    public val recommendedConfiguration: DiskVolumeConfigurationResponse? = null,
    public val supportedConfigurations: List<DiskDetailsResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SAPDiskConfigurationResponse):
            SAPDiskConfigurationResponse = SAPDiskConfigurationResponse(
            recommendedConfiguration = javaType.recommendedConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DiskVolumeConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            supportedConfigurations = javaType.supportedConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
