@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The SAP supported SKU.
 * @property isAppServerCertified True if the Sku is certified for App server in the SAP system.
 * @property isDatabaseCertified True if the Sku is certified for Database server in the SAP system.
 * @property vmSku The VM Sku.
 */
public data class SAPSupportedSkuResponse(
    public val isAppServerCertified: Boolean? = null,
    public val isDatabaseCertified: Boolean? = null,
    public val vmSku: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SAPSupportedSkuResponse):
            SAPSupportedSkuResponse = SAPSupportedSkuResponse(
            isAppServerCertified = javaType.isAppServerCertified().map({ args0 -> args0 }).orElse(null),
            isDatabaseCertified = javaType.isDatabaseCertified().map({ args0 -> args0 }).orElse(null),
            vmSku = javaType.vmSku().map({ args0 -> args0 }).orElse(null),
        )
    }
}
