@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SAP Software configuration Input when the software is to be installed by service.
 * @property bomUrl The URL to the SAP Build of Materials(BOM) file.
 * @property highAvailabilitySoftwareConfiguration Gets or sets the HA software configuration.
 * @property sapBitsStorageAccountId The SAP bits storage account id.
 * @property sapFqdn The FQDN to set for the SAP system during install.
 * @property softwareInstallationType The SAP software installation Type.
 * Expected value is 'ServiceInitiated'.
 * @property softwareVersion The software version to install.
 * @property sshPrivateKey The SSH private key.
 */
public data class ServiceInitiatedSoftwareConfigurationResponse(
    public val bomUrl: String,
    public val highAvailabilitySoftwareConfiguration: HighAvailabilitySoftwareConfigurationResponse? =
        null,
    public val sapBitsStorageAccountId: String,
    public val sapFqdn: String,
    public val softwareInstallationType: String,
    public val softwareVersion: String,
    public val sshPrivateKey: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ServiceInitiatedSoftwareConfigurationResponse):
            ServiceInitiatedSoftwareConfigurationResponse =
            ServiceInitiatedSoftwareConfigurationResponse(
                bomUrl = javaType.bomUrl(),
                highAvailabilitySoftwareConfiguration = javaType.highAvailabilitySoftwareConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.HighAvailabilitySoftwareConfigurationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sapBitsStorageAccountId = javaType.sapBitsStorageAccountId(),
                sapFqdn = javaType.sapFqdn(),
                softwareInstallationType = javaType.softwareInstallationType(),
                softwareVersion = javaType.softwareVersion(),
                sshPrivateKey = javaType.sshPrivateKey(),
            )
    }
}
