@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Snapshot Backup related fields for WorkloadType SAP Hana system
 * @property instantRPDetails Instant RP details for the snapshot.
 * @property instantRpRetentionRangeInDays Retention range for instant Rp in days.
 * @property userAssignedManagedIdentityDetails User Assigned managed identity details used for snapshot policy.
 */
public data class SnapshotBackupAdditionalDetailsResponse(
    public val instantRPDetails: String? = null,
    public val instantRpRetentionRangeInDays: Int? = null,
    public val userAssignedManagedIdentityDetails: UserAssignedManagedIdentityDetailsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SnapshotBackupAdditionalDetailsResponse):
            SnapshotBackupAdditionalDetailsResponse = SnapshotBackupAdditionalDetailsResponse(
            instantRPDetails = javaType.instantRPDetails().map({ args0 -> args0 }).orElse(null),
            instantRpRetentionRangeInDays = javaType.instantRpRetentionRangeInDays().map({ args0 ->
                args0
            }).orElse(null),
            userAssignedManagedIdentityDetails = javaType.userAssignedManagedIdentityDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedManagedIdentityDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
