@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User assigned managed identity properties.
 * @property clientId
 * @property principalId
 */
public data class UserAssignedIdentityPropertiesResponse(
    public val clientId: String? = null,
    public val principalId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.UserAssignedIdentityPropertiesResponse):
            UserAssignedIdentityPropertiesResponse = UserAssignedIdentityPropertiesResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
