@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User assigned managed identity details.
 * @property identityArmId
 * @property identityName
 * @property userAssignedIdentityProperties User assigned managed identity properties.
 */
public data class UserAssignedManagedIdentityDetailsResponse(
    public val identityArmId: String? = null,
    public val identityName: String? = null,
    public val userAssignedIdentityProperties: UserAssignedIdentityPropertiesResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.UserAssignedManagedIdentityDetailsResponse):
            UserAssignedManagedIdentityDetailsResponse = UserAssignedManagedIdentityDetailsResponse(
            identityArmId = javaType.identityArmId().map({ args0 -> args0 }).orElse(null),
            identityName = javaType.identityName().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentityProperties = javaType.userAssignedIdentityProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.UserAssignedIdentityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
