@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin

import com.pulumi.azurenative.aad.kotlin.outputs.ConfigDiagnosticsResponse
import com.pulumi.azurenative.aad.kotlin.outputs.DomainSecuritySettingsResponse
import com.pulumi.azurenative.aad.kotlin.outputs.LdapsSettingsResponse
import com.pulumi.azurenative.aad.kotlin.outputs.MigrationPropertiesResponse
import com.pulumi.azurenative.aad.kotlin.outputs.NotificationSettingsResponse
import com.pulumi.azurenative.aad.kotlin.outputs.ReplicaSetResponse
import com.pulumi.azurenative.aad.kotlin.outputs.ResourceForestSettingsResponse
import com.pulumi.azurenative.aad.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.aad.kotlin.outputs.ConfigDiagnosticsResponse.Companion.toKotlin as configDiagnosticsResponseToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.DomainSecuritySettingsResponse.Companion.toKotlin as domainSecuritySettingsResponseToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.LdapsSettingsResponse.Companion.toKotlin as ldapsSettingsResponseToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.MigrationPropertiesResponse.Companion.toKotlin as migrationPropertiesResponseToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.NotificationSettingsResponse.Companion.toKotlin as notificationSettingsResponseToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.ReplicaSetResponse.Companion.toKotlin as replicaSetResponseToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.ResourceForestSettingsResponse.Companion.toKotlin as resourceForestSettingsResponseToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DomainService].
 */
@PulumiTagMarker
public class DomainServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainServiceArgs = DomainServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainServiceArgsBuilder.() -> Unit) {
        val builder = DomainServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainService {
        val builtJavaResource = com.pulumi.azurenative.aad.DomainService(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainService(builtJavaResource)
    }
}

/**
 * Domain service.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2017-06-01.
 * ## Example Usage
 * ### Create Domain Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domainService = new AzureNative.Aad.DomainService("domainService", new()
 *     {
 *         DomainName = "TestDomainService.com",
 *         DomainSecuritySettings = new AzureNative.Aad.Inputs.DomainSecuritySettingsArgs
 *         {
 *             NtlmV1 = AzureNative.Aad.NtlmV1.Enabled,
 *             SyncNtlmPasswords = AzureNative.Aad.SyncNtlmPasswords.Enabled,
 *             TlsV1 = AzureNative.Aad.TlsV1.Disabled,
 *         },
 *         DomainServiceName = "TestDomainService.com",
 *         FilteredSync = AzureNative.Aad.FilteredSync.Enabled,
 *         LdapsSettings = new AzureNative.Aad.Inputs.LdapsSettingsArgs
 *         {
 *             ExternalAccess = AzureNative.Aad.ExternalAccess.Enabled,
 *             Ldaps = AzureNative.Aad.Ldaps.Enabled,
 *             PfxCertificate = "MIIDPDCCAiSgAwIBAgIQQUI9P6tq2p9OFIJa7DLNvTANBgkqhkiG9w0BAQsFADAgMR4w...",
 *             PfxCertificatePassword = "<pfxCertificatePassword>",
 *         },
 *         NotificationSettings = new AzureNative.Aad.Inputs.NotificationSettingsArgs
 *         {
 *             AdditionalRecipients = new[]
 *             {
 *                 "jicha@microsoft.com",
 *                 "caalmont@microsoft.com",
 *             },
 *             NotifyDcAdmins = AzureNative.Aad.NotifyDcAdmins.Enabled,
 *             NotifyGlobalAdmins = AzureNative.Aad.NotifyGlobalAdmins.Enabled,
 *         },
 *         ReplicaSets = new[]
 *         {
 *             new AzureNative.Aad.Inputs.ReplicaSetArgs
 *             {
 *                 Location = "West US",
 *                 SubnetId = "/subscriptions/1639790a-76a2-4ac4-98d9-8562f5dfcb4d/resourceGroups/TestNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/TestVnetWUS/subnets/TestSubnetWUS",
 *             },
 *         },
 *         ResourceGroupName = "TestResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aad/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aad.NewDomainService(ctx, "domainService", &aad.DomainServiceArgs{
 * 			DomainName: pulumi.String("TestDomainService.com"),
 * 			DomainSecuritySettings: &aad.DomainSecuritySettingsArgs{
 * 				NtlmV1:            pulumi.String(aad.NtlmV1Enabled),
 * 				SyncNtlmPasswords: pulumi.String(aad.SyncNtlmPasswordsEnabled),
 * 				TlsV1:             pulumi.String(aad.TlsV1Disabled),
 * 			},
 * 			DomainServiceName: pulumi.String("TestDomainService.com"),
 * 			FilteredSync:      pulumi.String(aad.FilteredSyncEnabled),
 * 			LdapsSettings: &aad.LdapsSettingsArgs{
 * 				ExternalAccess:         pulumi.String(aad.ExternalAccessEnabled),
 * 				Ldaps:                  pulumi.String(aad.LdapsEnabled),
 * 				PfxCertificate:         pulumi.String("MIIDPDCCAiSgAwIBAgIQQUI9P6tq2p9OFIJa7DLNvTANBgkqhkiG9w0BAQsFADAgMR4w..."),
 * 				PfxCertificatePassword: pulumi.String("<pfxCertificatePassword>"),
 * 			},
 * 			NotificationSettings: &aad.NotificationSettingsArgs{
 * 				AdditionalRecipients: pulumi.StringArray{
 * 					pulumi.String("jicha@microsoft.com"),
 * 					pulumi.String("caalmont@microsoft.com"),
 * 				},
 * 				NotifyDcAdmins:     pulumi.String(aad.NotifyDcAdminsEnabled),
 * 				NotifyGlobalAdmins: pulumi.String(aad.NotifyGlobalAdminsEnabled),
 * 			},
 * 			ReplicaSets: aad.ReplicaSetArray{
 * 				&aad.ReplicaSetArgs{
 * 					Location: pulumi.String("West US"),
 * 					SubnetId: pulumi.String("/subscriptions/1639790a-76a2-4ac4-98d9-8562f5dfcb4d/resourceGroups/TestNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/TestVnetWUS/subnets/TestSubnetWUS"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("TestResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aad.DomainService;
 * import com.pulumi.azurenative.aad.DomainServiceArgs;
 * import com.pulumi.azurenative.aad.inputs.DomainSecuritySettingsArgs;
 * import com.pulumi.azurenative.aad.inputs.LdapsSettingsArgs;
 * import com.pulumi.azurenative.aad.inputs.NotificationSettingsArgs;
 * import com.pulumi.azurenative.aad.inputs.ReplicaSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domainService = new DomainService("domainService", DomainServiceArgs.builder()
 *             .domainName("TestDomainService.com")
 *             .domainSecuritySettings(DomainSecuritySettingsArgs.builder()
 *                 .ntlmV1("Enabled")
 *                 .syncNtlmPasswords("Enabled")
 *                 .tlsV1("Disabled")
 *                 .build())
 *             .domainServiceName("TestDomainService.com")
 *             .filteredSync("Enabled")
 *             .ldapsSettings(LdapsSettingsArgs.builder()
 *                 .externalAccess("Enabled")
 *                 .ldaps("Enabled")
 *                 .pfxCertificate("MIIDPDCCAiSgAwIBAgIQQUI9P6tq2p9OFIJa7DLNvTANBgkqhkiG9w0BAQsFADAgMR4w...")
 *                 .pfxCertificatePassword("<pfxCertificatePassword>")
 *                 .build())
 *             .notificationSettings(NotificationSettingsArgs.builder()
 *                 .additionalRecipients(
 *                     "jicha@microsoft.com",
 *                     "caalmont@microsoft.com")
 *                 .notifyDcAdmins("Enabled")
 *                 .notifyGlobalAdmins("Enabled")
 *                 .build())
 *             .replicaSets(ReplicaSetArgs.builder()
 *                 .location("West US")
 *                 .subnetId("/subscriptions/1639790a-76a2-4ac4-98d9-8562f5dfcb4d/resourceGroups/TestNetworkResourceGroup/providers/Microsoft.Network/virtualNetworks/TestVnetWUS/subnets/TestSubnetWUS")
 *                 .build())
 *             .resourceGroupName("TestResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aad:DomainService TestDomainService.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AAD/domainServices/{domainServiceName}
 * ```
 */
public class DomainService internal constructor(
    override val javaResource: com.pulumi.azurenative.aad.DomainService,
) : KotlinCustomResource(javaResource, DomainServiceMapper) {
    /**
     * Configuration diagnostics data containing latest execution from client.
     */
    public val configDiagnostics: Output<ConfigDiagnosticsResponse>?
        get() = javaResource.configDiagnostics().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> configDiagnosticsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Deployment Id
     */
    public val deploymentId: Output<String>
        get() = javaResource.deploymentId().applyValue({ args0 -> args0 })

    /**
     * Domain Configuration Type
     */
    public val domainConfigurationType: Output<String>?
        get() = javaResource.domainConfigurationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Azure domain that the user would like to deploy Domain Services to.
     */
    public val domainName: Output<String>?
        get() = javaResource.domainName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * DomainSecurity Settings
     */
    public val domainSecuritySettings: Output<DomainSecuritySettingsResponse>?
        get() = javaResource.domainSecuritySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainSecuritySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource etag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Enabled or Disabled flag to turn on Group-based filtered sync
     */
    public val filteredSync: Output<String>?
        get() = javaResource.filteredSync().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Secure LDAP Settings
     */
    public val ldapsSettings: Output<LdapsSettingsResponse>?
        get() = javaResource.ldapsSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ldapsSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Migration Properties
     */
    public val migrationProperties: Output<MigrationPropertiesResponse>
        get() = javaResource.migrationProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                migrationPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Notification Settings
     */
    public val notificationSettings: Output<NotificationSettingsResponse>?
        get() = javaResource.notificationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> notificationSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * the current deployment or provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of ReplicaSets
     */
    public val replicaSets: Output<List<ReplicaSetResponse>>?
        get() = javaResource.replicaSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> replicaSetResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource Forest Settings
     */
    public val resourceForestSettings: Output<ResourceForestSettingsResponse>?
        get() = javaResource.resourceForestSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceForestSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Sku Type
     */
    public val sku: Output<String>?
        get() = javaResource.sku().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The unique sync application id of the Azure AD Domain Services deployment.
     */
    public val syncApplicationId: Output<String>
        get() = javaResource.syncApplicationId().applyValue({ args0 -> args0 })

    /**
     * SyncOwner ReplicaSet Id
     */
    public val syncOwner: Output<String>
        get() = javaResource.syncOwner().applyValue({ args0 -> args0 })

    /**
     * All or CloudOnly, All users in AAD are synced to AAD DS domain or only users actively syncing in the cloud
     */
    public val syncScope: Output<String>?
        get() = javaResource.syncScope().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure Active Directory Tenant Id
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Data Model Version
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object DomainServiceMapper : ResourceMapper<DomainService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.aad.DomainService::class == javaResource::class

    override fun map(javaResource: Resource): DomainService = DomainService(
        javaResource as
            com.pulumi.azurenative.aad.DomainService,
    )
}

/**
 * @see [DomainService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainService].
 */
public suspend fun domainService(
    name: String,
    block: suspend DomainServiceResourceBuilder.() -> Unit,
): DomainService {
    val builder = DomainServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainService(name: String): DomainService {
    val builder = DomainServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
